-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Glib;
with Gtk.Box;
package body mcc.tki.Window_Peer is

   ----------------
   -- Get_Window --
   ----------------

   function Get_Window
     (Window : in mcc.tki.Container.Window.Window'Class)
      return   Gtk.Widget.Gtk_Widget
   is
      Parent : Gtk.Widget.Gtk_Widget;
   begin
      -- Window is pointing to a Gtk_Fixed, which has a parent
      -- of a Gtk_Vbox, whose parent is the window
      Parent :=
         Gtk.Widget.Get_Parent
           (Gtk.Widget.Gtk_Widget (mcc.tki.Container.Window.Get_Peer
                                      (Window)));
      return Gtk.Widget.Get_Parent
               (Gtk.Widget.Get_Parent
                   (Gtk.Widget.Gtk_Widget (
        mcc.tki.Container.Window.Get_Peer (Window))));
   end Get_Window;

   function Has_Menu
     (Window : in mcc.tki.Container.Window.Window'Class)
      return   Boolean
   is
      Vbox     : Gtk.Box.Gtk_Vbox;
      Children : Gtk.Widget.Widget_List.Glist;
      use type Glib.Guint;
   begin
      Vbox     :=
        Gtk.Box.Gtk_Vbox (Gtk.Widget.Get_Parent
                             (Gtk.Widget.Gtk_Widget (
        mcc.tki.Container.Window.Get_Peer (Window))));
      Children := Gtk.Box.Children (Vbox);
      if Gtk.Widget.Widget_List.Length (Children) > 1 then
         return True;
      else
         return False;
      end if;
   end Has_Menu;

end mcc.tki.Window_Peer;
