-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Gdk;
with Gdk.Color;
with Glib;
with Gtk.Enums;
with Gtk.Widget;
with Gtk.Style;
with mcc.tki.Container;
with peer.Style;
with Gtk.Tooltips;

package body mcc.tki.Widget is

   ----------------
   -- Get_Parent --
   ----------------

   function Get_Parent
     (Obj  : in Widget'Class)
      return mcc.tki.Container.Container_Pointer
   is
   begin
      return Obj.Parent;
   end Get_Parent;

   --------------------------
   -- Set_Foreground_Color --
   --------------------------

   procedure Set_Foreground_Color
     (Obj       : in out Widget;
      New_Color : in Color)
   is
      old_style : Gtk.Style.Gtk_Style;
      new_style : Gtk.Style.Gtk_Style;
      color     : Gdk.Color.Gdk_Color;
      colormap  : Gdk.Color.Gdk_Colormap;
      success   : Boolean;
   begin--Set_Foreground_Color
      --Set color
      -- Note RGB colors are out of 65536 possible, not 256
      Gdk.Color.Set_Rgb
        (Color => color,
         Red   => Glib.Guint16 (New_Color.Red * 65535 / 255),
         Green => Glib.Guint16 (New_Color.Green * 65535 / 255),
         Blue  => Glib.Guint16 (New_Color.Blue * 65535 / 255));
      Gdk.Color.Set_Pixel (Color => color, Pixel => 0);
      colormap := Gtk.Widget.Get_Default_Colormap;
      Gdk.Color.Alloc_Color
        (Colormap   => colormap,
         Color      => color,
         Writeable  => True,
         Best_Match => True,
         Success    => success);

      --create a new_style
      old_style :=
         Gtk.Widget.Get_Style (Gtk.Widget.Gtk_Widget (Obj.My_Peer));
      new_style := Gtk.Style.Copy (old_style);

      --Change color for each of the five states
      Gtk.Style.Set_Foreground (new_style, Gtk.Enums.State_Normal, color);
      Gtk.Style.Set_Foreground (new_style, Gtk.Enums.State_Active, color);
      Gtk.Style.Set_Foreground (new_style, Gtk.Enums.State_Prelight, color);
      Gtk.Style.Set_Foreground (new_style, Gtk.Enums.State_Selected, color);
      Gtk.Style.Set_Foreground
        (new_style,
         Gtk.Enums.State_Insensitive,
         color);
      Gtk.Style.Set_Text (new_style, Gtk.Enums.State_Normal, color);
      Gtk.Style.Set_Text (new_style, Gtk.Enums.State_Active, color);
      Gtk.Style.Set_Text (new_style, Gtk.Enums.State_Prelight, color);
      Gtk.Style.Set_Text (new_style, Gtk.Enums.State_Selected, color);
      Gtk.Style.Set_Text (new_style, Gtk.Enums.State_Insensitive, color);
      peer.Style.Set_Style_Recursively
        (Widget => Gtk.Widget.Gtk_Widget (Obj.My_Peer),
         Style  => new_style);
   end Set_Foreground_Color;

   ----------------------
   -- Set_Tooltip_Text --
   ----------------------

   procedure Set_Tooltip_Text (Obj : in out Widget; Text : in String) is

      new_tooltip : Gtk.Tooltips.Gtk_Tooltips;

   begin--Set_Tooltip_Text
      Gtk.Tooltips.Gtk_New (Widget => new_tooltip);
      Gtk.Tooltips.Set_Tip
        (Tooltips => new_tooltip,
         Widget   => Gtk.Widget.Gtk_Widget (Obj.My_Peer),
         Tip_Text => Text);
   end Set_Tooltip_Text;

   -----------
   -- focus --
   -----------

   procedure focus (obj : in Widget) is
   begin
      Gtk.Widget.Grab_Focus (Gtk.Widget.Gtk_Widget (Obj.My_Peer));   -- 2003042
                                                                     --5ph
   end focus;

end mcc.tki.Widget;
