-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Gdk;
with Glib;
with Gtk.Object;
with Gtk.Container;
with Gtk.Event_Box;
with Gtk.Widget;
with peer.Image;          use peer.Image;
with mcc.tki.Widget.Peer;
package body mcc.tki.Widget.Picture is

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj    : in out Picture;
      Parent : in mcc.tki.Container.Container'Class;
      X      : in Integer;
      Y      : in Integer;
      Width  : in Natural;
      Height : in Natural;
      Image  : in mcc.tki.Image.Image'Class)
   is
      New_Event_Box : Gtk.Event_Box.Gtk_Event_Box;
   begin
      Gtk.Event_Box.Gtk_New (New_Event_Box);
      Obj.My_Peer := Gtk.Object.Gtk_Object (New_Event_Box);
      mcc.tki.Widget.Peer.Setup
        (Obj    => Obj,
         X      => X,
         Y      => Y,
         Width  => Width,
         Height => Height,
         Parent => Parent);

      Initialize
        (Image  => Mcc_Gtk_Image_Record (mcc.tki.Image.Get_Peer (Image).all),
         Widget => Gtk.Widget.Gtk_Widget (Obj.My_Peer));
      Gtk.Container.Add
        (Container => Gtk.Container.Gtk_Container (New_Event_Box),
         Widget    =>
           Mcc_Gtk_Image_Record (mcc.tki.Image.Get_Peer (Image).all).Pixmap);
   end Create;

   ---------------
   -- Set_Image --
   ---------------

   procedure Set_Image
     (Obj   : in out Picture;
      Image : in mcc.tki.Image.Image'Class)
   is
      Child_List : Gtk.Widget.Widget_List.Glist;
   begin

      Child_List :=
         Gtk.Container.Children
           (Container => Gtk.Container.Gtk_Container (Obj.My_Peer));
      Gtk.Container.Remove
        (Container => Gtk.Container.Gtk_Container (Obj.My_Peer),
         Widget    =>
            Gtk.Widget.Widget_List.Nth_Data
              (List => Child_List,
               N    => Glib.Guint (0)));
      Initialize
        (Image  => Mcc_Gtk_Image_Record (mcc.tki.Image.Get_Peer (Image).all),
         Widget => Gtk.Widget.Gtk_Widget (Obj.My_Peer));
      Gtk.Container.Add
        (Container => Gtk.Container.Gtk_Container (Obj.My_Peer),
         Widget    =>
           Mcc_Gtk_Image_Record (mcc.tki.Image.Get_Peer (Image).all).Pixmap);
   end Set_Image;

end mcc.tki.Widget.Picture;
