-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Gdk;
with Gdk.Types;
with Gdk.Event;
with Gtk.Object;
with Gtk.Container;
with Gtk.Enums;
with Gtk.Event_Box;
with Gtk.List;
with Gtk.Scrolled_Window;
with Gtk.Widget;
with mcc.tki.Widget.Peer;
with peer;
with peer.Gtk_List;       use peer.Gtk_List;
package body mcc.tki.Widget.Listbox is

   type Mcc_Listbox_Record is new Gtk.Event_Box.Gtk_Event_Box_Record with
      record
         Listbox : Gtk.List.Gtk_List;
      end record;
   type Mcc_Listbox is access all Mcc_Listbox_Record'Class;

   ---------------
   -- Add_Entry --
   ---------------

   procedure Add_Entry
     (Obj      : in out Listbox;
      Location : in Natural;
      Text     : in String)
   is
   begin
      Add_Entry (Mcc_Listbox (Obj.My_Peer).Listbox, Location, Text);
   end Add_Entry;

   -----------
   -- Clear --
   -----------

   procedure Clear (Obj : in out Listbox) is
   begin
      Clear (Mcc_Listbox (Obj.My_Peer).Listbox);
   end Clear;

   -----------
   -- Count --
   -----------

   function Count (Obj : in Listbox) return Natural is
   begin
      return Count (Mcc_Listbox (Obj.My_Peer).Listbox);
   end Count;

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj                  : in out Listbox;
      Parent               : in mcc.tki.Container.Container'Class;
      X                    : in Integer;
      Y                    : in Integer;
      Width                : in Natural;
      Height               : in Natural;
      Horizontal_Scrollbar : in Boolean;
      Vertical_Scrollbar   : in Boolean)
   is
      New_Scrolled  : Gtk.Scrolled_Window.Gtk_Scrolled_Window;
      Horizontal    : Gtk.Enums.Gtk_Policy_Type;
      Vertical      : Gtk.Enums.Gtk_Policy_Type;
      New_Event_Box : Mcc_Listbox;
      use type Gdk.Event.Gdk_Event_Mask;
   begin
      New_Event_Box := new Mcc_Listbox_Record;
      Gtk.Event_Box.Initialize (Gtk.Event_Box.Gtk_Event_Box (New_Event_Box));
      Obj.My_Peer := Gtk.Object.Gtk_Object (New_Event_Box);

      Gtk.Scrolled_Window.Gtk_New (New_Scrolled);
      Gtk.List.Gtk_New (Widget => New_Event_Box.Listbox);
      Gtk.Widget.Add_Events
        (Widget => Gtk.Widget.Gtk_Widget (New_Event_Box.Listbox),
         Events => Gdk.Event.Button_Motion_Mask +
                   Gdk.Event.Key_Release_Mask +
                   Gdk.Event.Key_Press_Mask +
                   Gdk.Event.Button_Press_Mask +
                   Gdk.Event.Button_Release_Mask +
                   Gdk.Event.Pointer_Motion_Mask);

      --Attach a horizontal scrollbar
      if Horizontal_Scrollbar then
         Horizontal := Gtk.Enums.Policy_Always;
      else
         Horizontal := Gtk.Enums.Policy_Never;
      end if;

      --Attach a vertical scrollbar
      if Vertical_Scrollbar then
         Vertical := Gtk.Enums.Policy_Always;
      else
         Vertical := Gtk.Enums.Policy_Never;
      end if;

      Gtk.Scrolled_Window.Set_Policy
        (Scrolled_Window    => New_Scrolled,
         H_Scrollbar_Policy => Horizontal,
         V_Scrollbar_Policy => Vertical);

      Gtk.Scrolled_Window.Add_With_Viewport
        (Scrolled_Window => New_Scrolled,
         Child           => New_Event_Box.Listbox);
      Gtk.List.Show (New_Event_Box.Listbox);

      --Set selection mode to single, not multiple
      Gtk.List.Set_Selection_Mode
        (List => New_Event_Box.Listbox,
         Mode => Gtk.Enums.Selection_Single);

      Gtk.Scrolled_Window.Show (New_Scrolled);
      Gtk.Container.Add
        (Container => Gtk.Container.Gtk_Container (New_Event_Box),
         Widget    => New_Scrolled);

      mcc.tki.Widget.Peer.Setup
        (Obj    => Obj,
         X      => X,
         Y      => Y,
         Width  => Width,
         Height => Height,
         Parent => Parent);
   end Create;

   ------------------
   -- Delete_Entry --
   ------------------

   procedure Delete_Entry
     (Obj   : in out Listbox;
      Start : in Natural;
      Stop  : in Natural)
   is
   begin
      Delete_Entry (Mcc_Listbox (Obj.My_Peer).Listbox, Start, Stop);
   end Delete_Entry;

   ------------------------------------------------
   -- function Get_Item
   --
   -- return text of item numbered
   ------------------------------------------------
   function Get_Item (Obj : in Listbox; Number : in Natural) return String is
   begin
      raise Constraint_Error;
      return "";
   end Get_Item;

   ------------------
   -- Get_Selected --
   ------------------

   function Get_Selected (Obj : in Listbox) return Natural is
   begin
      return Get_Selected (Mcc_Listbox (Obj.My_Peer).Listbox);
   end Get_Selected;

   -----------------
   -- Select_Item --
   -----------------

   procedure Select_Item (Obj : in out Listbox; Number : in Natural) is
   begin
      Select_Item (Mcc_Listbox (Obj.My_Peer).Listbox, Number);
   end Select_Item;

end mcc.tki.Widget.Listbox;
