-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Glib;                use Glib;
with Gdk;
with Gtk.Container;
with Gtk.Event_Box;
with Gtk.Label;
with Gtk.Misc;
with Gtk.Widget;
with Gtk.Object;
with mcc.tki.Widget.Peer;
package body mcc.tki.Widget.Label is

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj     : in out Label;
      Parent  : in mcc.tki.Container.Container'Class;
      X       : in Integer;
      Y       : in Integer;
      Width   : in Natural;
      Height  : in Natural;
      Justify : in Justification;
      Text    : in String)
   is
      New_Label     : Gtk.Label.Gtk_Label;
      New_Event_Box : Gtk.Event_Box.Gtk_Event_Box;
   begin
      Gtk.Event_Box.Gtk_New (New_Event_Box);
      Obj.My_Peer := Gtk.Object.Gtk_Object (New_Event_Box);
      mcc.tki.Widget.Peer.Setup
        (Obj    => Obj,
         X      => X,
         Y      => Y,
         Width  => Width,
         Height => Height,
         Parent => Parent);

      Gtk.Label.Gtk_New (Label => New_Label, Str => Text);
      --Justify text horizontally and center vertically
      case Justify is
         when Left =>
            Gtk.Misc.Set_Alignment
              (Misc   => Gtk.Misc.Gtk_Misc (New_Label),
               Xalign => 0.0,
               Yalign => 0.5);
         when Right =>
            Gtk.Misc.Set_Alignment
              (Misc   => Gtk.Misc.Gtk_Misc (New_Label),
               Xalign => 1.0,
               Yalign => 0.5);
         when Center =>
            Gtk.Misc.Set_Alignment
              (Misc   => Gtk.Misc.Gtk_Misc (New_Label),
               Xalign => 0.5,
               Yalign => 0.5);
      end case;
      Gtk.Container.Add
        (Container => Gtk.Container.Gtk_Container (New_Event_Box),
         Widget    => New_Label);
      Gtk.Label.Show (New_Label);
   end Create;

   --------------
   -- Set_Text --
   --------------

   procedure Set_Text (Obj : in out Label; Text : in String) is
   begin
      Gtk.Label.Set_Text
        (Label =>
           Gtk.Label.Gtk_Label (Gtk.Widget.Widget_List.Get_Data
                                   (Gtk.Widget.Widget_List.First
                                       (Gtk.Container.Children
                                           (Gtk.Container.Gtk_Container (
        Obj.My_Peer))))),
         Str   => Text);
   end Set_Text;

end mcc.tki.Widget.Label;
