with Main_Window;
with Mcc.Tki.Widget.Label;

package body Main_Actions is
   -------------------------------------------------------------
   -- Procedure executed when the Go button is pushed.        --
   -------------------------------------------------------------
   procedure Go_Button_Pushed (
         Obj : in out Mcc.Tki.Widget.Button.Button'Class ) is 

      Window_Read : Boolean;  

   begin

      -- Read the information selected in the GUI window
      Main_Window.Read_Window(
         Success         => Window_Read, 
         Highlight_Error => True,        
         Beep_On_Error   => True);

      -- Do this only if the GUI was read sucessfully
      if Window_Read then

         Mcc.Tki.Widget.Label.Set_Text(
            Obj  => Main_Window.Echo_Rank,                                               
            Text => "The rank is:  " & Enum_Try.Cadet_Type'Image (Whichrank));

      end if;

   end Go_Button_Pushed;
   -------------------------------------------------------------
   -- Procedure executed when the Exit button is pushed.        --
   -------------------------------------------------------------
   procedure Exit_Button_Pushed (
         Obj : in out Mcc.Tki.Widget.Button.Button'Class ) is 

   begin

      Main_Window.Close_Window;

   end Exit_Button_Pushed;

end Main_Actions;
