-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           TCL PEER FOR THE MCC GUI PACKAGE LIBRARY
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with peer;
with Tcl;
with CArgv;
with Interfaces.C;
with My_Expanding_Array;
with Cargv_Helpers;
package body mcc.Gui.Widget.Button is
   Push_Command : Tcl.Tcl_Command;

   Have_Push_Command : Boolean := False;

   -------------
   -- Disable --
   -------------

   procedure Disable (Obj : in out Button) is
   begin
      peer.Eval (Obj.My_Peer.Name.all & " configure -state disabled");
   end Disable;

   ------------
   -- Enable --
   ------------

   procedure Enable (Obj : in out Button) is
   begin
      peer.Eval (Obj.My_Peer.Name.all & " configure -state normal");
   end Enable;

   --------------------------
   -- Tcl callback for
   -- Push events
   --------------------------
   function Push_Command_Function
     (ClientData : in Integer;
      Interp     : in Tcl.Tcl_Interp;
      Argc       : in Interfaces.C.int;
      Argv       : in CArgv.Chars_Ptr_Ptr)
      return       Interfaces.C.int;
   pragma Convention (C, Push_Command_Function);

   -- protocol for arguments will be
   -- 1st argument : lookup into Expanding_Array
   function Push_Command_Function
     (ClientData : in Integer;
      Interp     : in Tcl.Tcl_Interp;
      Argc       : in Interfaces.C.int;
      Argv       : in CArgv.Chars_Ptr_Ptr)
      return       Interfaces.C.int
   is
      Obj : Button_Pointer;
   begin
      Obj :=
        Button_Pointer (My_Expanding_Array.Retrieve
                           (Table    => My_Expanding_Array.Table,
                            Location => Cargv_Helpers.Argument (Argv, 1)));
      Obj.Push_Handler (Obj.all);
      return Tcl.TCL_OK;
   end Push_Command_Function;

   -----------------------
   -- Set_Push_Callback --
   -----------------------

   procedure Set_Push_Callback
     (Obj      : in Button_Pointer;
      Callback : in Push_Callback)
   is
   begin
      if Obj.My_Peer.Lookup = 0 then
         My_Expanding_Array.Insert
           (Table    => My_Expanding_Array.Table,
            Element  => Sized_Object_Pointer (Obj),
            Location => Obj.My_Peer.Lookup);
      end if;

      if not Have_Push_Command then
         Push_Command      :=
            peer.CreateCommands.Tcl_CreateCommand
              (peer.Get_Interp,
               "pushcommand",
               Push_Command_Function'Access,
               0,
               null);
         Have_Push_Command := True;
      end if;

      peer.Eval
        (Obj.My_Peer.Name.all &
         " configure -command " &
         "{pushcommand " & mcc.Img (Obj.My_Peer.Lookup) & "}");
      Obj.Push_Handler := Callback;
   end Set_Push_Callback;

   ------------------------------------------------
   -- procedure Depress
   --
   -- draw button as depressed
   ------------------------------------------------
   procedure Depress (Obj : in out Button) is
   begin
      peer.Eval (Obj.My_Peer.Name.all & " configure -relief sunken");
   end Depress;

   ------------------------------------------------
   -- procedure Release
   --
   -- draw button as released (raised)
   ------------------------------------------------
   procedure Release (Obj : in out Button) is
   begin
      peer.Eval (Obj.My_Peer.Name.all & " configure -relief raised");
   end Release;
   --------------
   -- Set_Text --
   --------------

   procedure Set_Text (Obj : in out Labeled_Button; Text : in String) is
   begin
      peer.Eval
        (Obj.My_Peer.Name.all &
         " configure -text " &
         '"' &
         peer.Fix_Quotes (Text) &
         '"');
   end Set_Text;
   -----------------------
   -- Get_Push_Callback --
   -----------------------

   function Get_Push_Callback (Obj : in Button'Class) return Push_Callback is
   begin
      return Obj.Push_Handler;
   end Get_Push_Callback;

end Mcc.Gui.Widget.Button;
