---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  MCC.TEXT_ENTRY_TYPES
--  Description : specifies types for auto-fill of Text_Entry
--
--  Copyright (C) 2000, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with Interfaces;

package mcc.text_entry_types is

   type Base_Type is (
      Unbounded_String,
      Integer,
      Unsigned,
      Enumeration,
      Float_1,
      Float_2,
      Float_3,
      Float_E);

   subtype Float_Types is Base_Type range Float_1 .. Float_E;

   -- used to hold a base_type temporarily so it can be copied
   -- into a record
   Default_Base_Type : Base_Type := Unbounded_String;

   ----------------------------------------------
   -- function(s) Image take in data and convert
   -- it to a string to fill in the text_entry
   -- not provided for enumeration (use 'image)
   -- or unbounded_string (use to_string).
   ----------------------------------------------
   function Image (data : in Interfaces.Unsigned_32) return String;

   function Image (data : in Float; base : in Float_Types) return String;

end mcc.text_entry_types;
