---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  gui-widget-frame.ads
--  Description : GUI WidgetFrame
--
--  By: Stephen A. Griffin
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
--
-- Copyright (C) 2005, SA Griffin <stephen.griffin.external@eads.com>
---------------------------------------------------------------------

with mcc.Gui.Container;
with mcc.Gui.Widget.Button.Check;

package gui.Widget.Frame is

   type Frame is new GUI_Widget with record
      Border_Width       : Integer;
      Border_Width_Entry : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
   end record;

   -- Reads information from file
   procedure Read_Widget (Widget : in out Frame);

   -- Writes information to file
   procedure Write_Widget
     (Widget : in Frame);

   procedure Generate_Action_Context_Clause
     (Widget : in Frame);

   procedure Generate_Widget_Context_Clause
     (Widget : in Frame);

   procedure Generate_Widget_Declaration
     (Widget : in Frame);

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Frame;
      Container : in out mcc.Gui.Container.Container'Class);

   procedure Generate_Widget_Creation
     (Widget      : in Frame;
      Window_Name : in String);

   procedure Set_Properties (Widget : in out Frame);

   procedure Apply_Properties (Widget : in out Frame);

   procedure Check_Properties (Widget : in out Frame; Ok : out Boolean);

end Gui.Widget.Frame;
