------------------------------------------------------------------------------
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
--Converts an integer subtype intensity into a HEX string
-- Copyright (C) 1999, Jonathan Busch
--

with Ada.Integer_Text_IO;
with Ada.Text_IO;
with mcc.Gui;             use mcc.Gui;

package body Hex is

   function Hex_String (Data : mcc.Gui.Intensity) return String is
      Temp_String : String (1 .. 6);

   begin -- Hex_String
      Ada.Integer_Text_IO.Put
        (To   => Temp_String,
         Item => Integer (Data),
         Base => 16);
      if Temp_String (4) = '#' then
         Temp_String (4) := '0';
      end if;
      return Temp_String (4 .. 5);
   end Hex_String;

end Hex;
