/*
 * Decompiled with CFR 0.152.
 */
package org.qsos.utils;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.qsos.data.IElement;
import org.qsos.data.ISheet;
import org.qsos.utils.SimpleMenuEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Search {
    private ISheet sheet;
    private String name;
    private int numDesc;
    private String string2set;
    private String type;

    public void setSheet(ISheet sheet) {
        this.sheet = sheet;
    }

    public List<IElement> searchByName() throws IOException {
        LinkedList<IElement> list = new LinkedList<IElement>();
        return this.searchRecByName(this.sheet.getRoot(), list);
    }

    public List<IElement> searchRecByName(IElement target, List<IElement> list) throws IOException {
        if (target.getElements() != null) {
            for (IElement child : target.getElements()) {
                if (child.getName() != null && child.getName().equals(this.name)) {
                    list.add(child);
                }
                this.searchRecByName(child, list);
            }
            return list;
        }
        return null;
    }

    public List<IElement> searchByMeta() throws IOException {
        LinkedList<IElement> list = new LinkedList<IElement>();
        return this.searchRecByMeta(this.sheet.getRoot(), list);
    }

    public List<IElement> searchRecByMeta(IElement target, List<IElement> list) {
        if (target.getElements() != null) {
            for (IElement child : target.getElements()) {
                if (child.getMeta() != null && child.getMeta().equals(this.name)) {
                    list.add(child);
                }
                this.searchRecByMeta(child, list);
            }
            return list;
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNumDesc(int numDesc) {
        this.numDesc = numDesc;
    }

    public String searchString() throws IOException {
        List<Object> list = new LinkedList();
        if (this.type.equals("name")) {
            list = this.searchByName();
        } else if (this.type.equals("meta")) {
            list = this.searchByMeta();
        } else {
            throw new IOException();
        }
        if (list.size() > 1) {
            String res = "";
            for (IElement iElement : list) {
                res = res + iElement.getText() + "\t";
            }
            return res;
        }
        if (list.size() == 1) {
            IElement temp = (IElement)list.get(0);
            if (this.numDesc == -1) {
                return temp.getText();
            }
            if (this.numDesc == 0) {
                return temp.getDesc0();
            }
            if (this.numDesc == 1) {
                return temp.getDesc1();
            }
            if (this.numDesc == 2) {
                return temp.getDesc2();
            }
            throw new IOException();
        }
        throw new IOException();
    }

    public IElement searchIElement() throws IOException {
        List<Object> list = new LinkedList();
        if (this.type.equals("name")) {
            list = this.searchByName();
        } else if (this.type.equals("meta")) {
            list = this.searchByMeta();
        }
        if (list.size() == 1) {
            return (IElement)list.get(0);
        }
        throw new IOException();
    }

    public void searchAndSet() {
        try {
            this.searchIElement().setText(this.string2set);
        }
        catch (IOException e) {
            System.err.println("Can't find Key");
        }
    }

    public String searchAndGetString() {
        try {
            return this.searchString();
        }
        catch (IOException e) {
            System.err.println("Can't find Key");
            return null;
        }
    }

    public IElement searchAndGetIElement() {
        try {
            return this.searchIElement();
        }
        catch (IOException e) {
            System.err.println("Can't find Key");
            return null;
        }
    }

    public void setString2set(String string2set) {
        this.string2set = string2set;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ISheet getSheet() {
        return this.sheet;
    }

    public List<SimpleMenuEntry> getSimpleTree() {
        LinkedList<SimpleMenuEntry> list = new LinkedList<SimpleMenuEntry>();
        IElement root = this.sheet.getRoot();
        int deep = 0;
        SimpleMenuEntry menu = new SimpleMenuEntry(0, root.getName(), root.getTitle());
        list.add(menu);
        this.getSimpleTreeRec(root, deep, list);
        return list;
    }

    private void getSimpleTreeRec(IElement root, int deep, List<SimpleMenuEntry> list) {
        if (root.getElements() != null) {
            for (IElement child : root.getElements()) {
                SimpleMenuEntry menu = new SimpleMenuEntry(deep + 1, child.getName(), child.getTitle());
                list.add(menu);
                this.getSimpleTreeRec(child, deep + 1, list);
            }
        }
    }
}

