/*
 * Decompiled with CFR 0.152.
 */
package org.qsos.data;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.qsos.data.IElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
implements IElement {
    private Long id;
    private String meta;
    private String name;
    private String title;
    private String text;
    private String desc;
    private String desc0;
    private String desc1;
    private String desc2;
    private String comment;
    private String score;
    private List<IElement> elements = null;
    private IElement container;

    public Element() {
        this.id = null;
        this.meta = "";
        this.name = "";
        this.title = "";
        this.text = "";
        this.elements = null;
        this.container = null;
        this.desc = "";
        this.desc0 = "";
        this.desc1 = "";
        this.desc2 = "";
        this.comment = "";
        this.score = "";
    }

    public Element(Long id, String meta, String name, String title, String text, List<IElement> list, IElement elem) {
        this.id = id;
        this.meta = meta;
        this.name = name;
        this.title = title;
        this.text = text;
        this.elements = list;
        this.container = elem;
        this.desc = "";
        this.desc0 = "";
        this.desc1 = "";
        this.desc2 = "";
        this.comment = "";
        this.score = "";
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getMeta() {
        return this.meta;
    }

    @Override
    public void setMeta(String meta) {
        this.meta = meta;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public List<IElement> getElements() {
        return this.elements;
    }

    @Override
    public void setElements(List<IElement> elements) {
        this.elements = elements;
    }

    @Override
    public IElement getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(IElement element) {
        this.container = element;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public void setDesc0(String desc0) {
        this.desc0 = desc0;
    }

    @Override
    public String getDesc0() {
        return this.desc0;
    }

    @Override
    public void setDesc1(String desc1) {
        this.desc1 = desc1;
    }

    @Override
    public String getDesc1() {
        return this.desc1;
    }

    @Override
    public void setDesc2(String desc2) {
        this.desc2 = desc2;
    }

    @Override
    public String getDesc2() {
        return this.desc2;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setScore(String score) throws IOException {
        this.score = score;
    }

    @Override
    public String getScore() {
        return this.score;
    }

    @Override
    public IElement addElement(IElement item) {
        if (item != null) {
            item.setContainer(this);
            if (this.elements == null) {
                this.elements = new LinkedList<IElement>();
            }
            this.elements.add(item);
        }
        return item;
    }

    @Override
    public void delElement(IElement item) {
        if (item != null) {
            if (item.getElements() != null) {
                for (IElement child : item.getElements()) {
                    this.delElement(child);
                }
            }
            this.elements.remove(item);
        }
    }

    @Override
    public String toString() {
        String element_as_string = "";
        element_as_string = element_as_string + "text:" + this.getText() + "\t";
        element_as_string = element_as_string + "meta:" + this.getMeta() + "\t";
        element_as_string = element_as_string + "name:" + this.getName() + "\t";
        element_as_string = this.elements == null || this.elements.isEmpty() ? element_as_string + "no childs\n" : element_as_string + this.elements.size() + " childs\n";
        return element_as_string;
    }

    @Override
    public String tree() {
        return Element.treeToString(this, "");
    }

    private static String treeToString(IElement element, String indent) {
        String tree = "";
        tree = tree + indent + ((Object)element).toString();
        List<IElement> listElements = element.getElements();
        if (listElements != null && !listElements.isEmpty()) {
            for (IElement containedElement : element.getElements()) {
                tree = tree + indent + Element.treeToString(containedElement, indent + "\t");
            }
        }
        return tree;
    }
}

