%{
/*
 * scanner.l - reader for /proc/cpuinfo files
 *
 * Copyright (C) 2006  Thomas Cort <linuxgeek@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */


#include <ctype.h>
#include <stdio.h>
#include <string.h>

int lineno;
char *s;
extern char *__proccpuinfo_key[];
char *proccpuinfo_get_filename();
void __proccpuinfo_remove_whitespace(char *buf);
static int yywrap(void);
%}

%%

[^\n]*[\n]	{ 
			lineno++;

			s = (char *) malloc(strlen(yytext)*sizeof(char*)+1);
			strcpy(s,yytext);
			s[strlen(s)-1] = '\0';
			return 1;
		}

.		{
			return 0;
		}
%%

int yywrap() {
	return 1;
}

char *__proccpuinfo_get_value(int target_key) {
	yyin = fopen(proccpuinfo_get_filename(),"r");

	if (!yyin) {
		return NULL;
	}

	while (yylex()) {
		char *key = s, *target_value, *delim, *value;

		delim = strchr(s,':');

		if (delim) {
			s[delim-s] = '\0';
			target_value = delim + 1;
		} else
			target_value = NULL;

		__proccpuinfo_remove_whitespace(key);
		if (key && target_value && strlen(key) == strlen(__proccpuinfo_key[target_key]) && !strcmp(key, __proccpuinfo_key[target_key])) {
				__proccpuinfo_remove_whitespace(target_value);

				if (!(value = (char *) malloc(strlen(target_value)+1))) {
					free(s);
					fclose(yyin);
					yylex_destroy();
					return NULL;
				}

				strncpy(value,target_value,strlen(target_value)+1);
				free(s);
				fclose(yyin);
				yylex_destroy();

				return value;

		}
		free(s);
	}

	fclose(yyin);
	yylex_destroy();
	return NULL;
}

int __proccpuinfo_get_count(int target_key) {
	unsigned int count = 0;
	yyin = fopen(proccpuinfo_get_filename(),"r");

	if (!yyin) {
		return 0;
	}

	while (yylex()) {
		char *key = s, *target_value, *delim;

		delim = strchr(s,':');

		if (delim) 
			s[delim-s] = '\0';

		__proccpuinfo_remove_whitespace(key);
		if (!strcmp(key, __proccpuinfo_key[target_key])) {
			count++;
		}
		free(s);
	}

	fclose(yyin);
	yylex_destroy();
	return count;
}
