// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __DIAGRAM_IMPL_H
#define __DIAGRAM_IMPL_H

// in the case of MSVC we have macros here named "max" and "IN" causing
// serious compilation errors later in the Board-header, so we undefine
// them her, we don't use them at all
#ifdef _MSC_VER
#undef max
#undef IN
#endif

#include "diagram.h"
#include "Board.h"

//=== DiagramSVG ===========================================================
class DiagramSVG: public Diagram {

	LibBoard::Board		m_canvas;
	LibBoard::Group		m_shapes;

	double			m_width;
	double			m_height;
	ptime			m_xmin;
	ptime			m_xmax;
	XUnit			m_xunit;
	double			m_ymin;
	double			m_ymax;
	double			m_yunit;

	public:

		DiagramSVG ();

	virtual	void OpenCanvas (size_t width, size_t height, RGB bgColor);
	virtual	void CloseCanvas ();

	virtual	void DrawAxes (const ptime& x_min, const ptime& x_max, XUnit x_unit, double y_min, double y_max, double y_unit, RGB color);
	virtual	void DrawAxes (FoldInterval fi, double y_min, double y_max, double y_unit, RGB color);
	virtual	void DrawCurve (const Selection& s, RGB color, LineStyle style, double thickness, bool continuous, int bar1, int bar2);
	virtual	void DrawVLine (const ptime& timestamp, RGB color, double thickness);
	virtual	void DrawHLine (double value, RGB color, double thickness);

	virtual void SaveAs (const string& filename) const;

	private:

	double CalcX (const ptime& x) const;
	double CalcY (double y) const;
	void NormalizeX (ptime& x, time_duration& increment) const;
};

#endif
