// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __OUT_H
#define __OUT_H

//=== Output (abstract base class) =========================================
//
// This is the base class for an output. An output gets informations from
// the database and transforms them into something else (a text report, a
// diagram). All action is done in the Do() method.
//
class Output {

	public:

	virtual ~Output ();

	virtual string GetVerboseName () const =0;
	virtual	void Do (const Config& config, const Database& database) const throw (Xception) =0;
};

//=== OutputFactory ========================================================
//
// This factory manages a vector of concrete output objects according to the
// output specifications made in the configuration file. After creation the
// vector can be iterated over to get the Do() methods of the output objects
// called one by one.
//
class OutputFactory {

	public:

	typedef vector<Output*> Outputs;

	protected:

	Outputs		m_outputs;
	bool		m_initialized;

	public:

		OutputFactory ();
	virtual	~OutputFactory ();

	const Outputs& GetOutputs (const Config& config) throw (Xception);
	Output* GetOutputInteractive () throw (Xception);
};

#endif
