/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.swools;

import java.awt.*;
import javax.swing.*;

/**  This class provides a set of (growing ?) utilities for  
 *  the manipulation of the GridBagLayout and the associate object GridBagConstraints 
 * 
 * @author Romain Pacanowski
 * @version 0.1
 * @since Ople-swools 0.11
 */

public class OGBLayoutUtilities {

   
  /** Set the GridBagConstraint's parameters
   *@param GridBagConstraints gbc, the GridBagConstraints
   *@param int weightx,      Specifies how to distribute extra horizontal space.
   *@param int weighty,      Specifies how to distribute extra vertical space.
   *@param int insetsLeft    The inset from  the left
   *@param int insetsRight   The inset from the right
   *@param int insetsTop     The inset from the top
   *@param int insetsBottom  The inset from the bottom
   *@see  java.awt.GridBagConstraints 
   *@see  java.awt.Insets
   */

  public static void setConstraints(GridBagConstraints gbc , int weightx ,int weighty, int insetsLeft , 
			 int insetsRight , int insetsTop, int insetsBottom ){
    gbc.weightx =weightx ;
    gbc.weighty =weighty ;

    gbc.insets.left = insetsLeft;
    gbc.insets.right = insetsRight;

    gbc.insets.top = insetsTop;
    gbc.insets.bottom = insetsBottom;

  }
  
  /** Add a component to a GridBagLayout a positon (x,y) with an weight w and height in a Container a 
   *@param Component c, the Component to add
   *@param GridBagConstraints gbc, the GridBagConstraints
   *@param int x , abscissa of the component
   *@param int y , ordinate of the component
   *@param int w , weight of the component
   *@param int h , height of the component
   *@param Container a, the container where the component will be add to. 
   *@see java.awt.GridBagConstraints
  */
  public static void add(Component c , GridBagConstraints gbc , int x , int y , int w , int h, Container a){

    gbc.gridx = x ;
    gbc.gridy = y ;
    gbc.gridwidth = w;
    gbc.gridheight = h;
    a.add(c,gbc);

  }





}
