/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d.object2d;
import opale.tools.*;
import opale.mathtools.*;
import opale.mathtools.parser.*;
import opale.m2d.*;
import java.util.Vector;
import java.io.*;
/**
* This class represents a cartesian function y =f(x).
* @since Opale-2d 0.1
* @author O.C.
*/

public class yFx extends Object2D implements Cloneable
{
private IyFx fonc;
private String sf="";
private boolean fromString=false;
//private ParseFunction parser;
private Parser parser;
private OIJ oij;
protected double xinf, xsup;
protected int N;

/**
* Default constructor.
*/
public yFx()
	{
	super();
	oij=new OIJ();
	if (Debug.On) Debug.print("Dans yFx()");
	//parser = new Parser();
	//parser.addVar("x");
	N=100;
	xinf =0;
	xsup = 10;
        fonc = new IyFx() { public double val(double x) {return 0;}};	
	}

/**
* Constructs the zero function in a specififed OIJ.  
* @param OIJ rep
*/
public yFx(OIJ rep)
	{
	super(rep);
	oij =  rep;
	//parser = new Parser();
	//parser.addVar("x");
	N=100;
	xinf =0;
	xsup = 10;
        fonc = new IyFx() { public double val(double x) {return 0;}};	
	}


/**
* Constructs an instance from an existing instance of yFx
* @param yFx d, object to be copied
*/
public yFx(yFx f)
	{
        super(f.getOIJ());
	oij = f.oij;
	fromString = f.fromString;
	if ( fromString )
		{
		sf = f.sf;
		parser = new Parser();
		parser.addVar("x");
/*		if (!parser.parse(sf))
			{
			System.err.println("Problme dans yFx(yFx f) : Ne devrait jamais arriver !!");
			System.exit(-1);
			}*/
		parser.parseString(sf)	;
		}
	else
		fonc=f.fonc;
	N = f.N;
	xinf=f.xinf;
	xsup=f.xsup;
	}

/**
* Returns the value of the function in a specified point.
* @aparam double x, point to be computed
*/
public double val(double x)
	{
	Matrix2D mv = new Matrix2D();
	oij.matPassage(getOIJ(),mv);
	double[] p = mv.compute(x,0);
	x = p[0];
	if ( fromString)
		{
		try
		{
		//double resu = parser.getResult(x);
		parser.setVar("x",x);
		double resu = parser.eval();
		getOIJ().matPassage(oij,mv);
		p = mv.compute(x,resu);
		return p[1];
		}
		catch (Exception e)
		{
		System.err.println(e);
		System.err.println("Ne devrait jamais arriver");
		}
		return 0;
		}
	else
		{
		double resu = fonc.val(x);
		getOIJ().matPassage(oij,mv);
		p = mv.compute(x,resu);
		return p[1];
		}
	}

/**
* Sets the function, the bounds of its definition domain and the number of points to be used to draw it. 
* @param IyFx f, the function
* @param double xinf, xsup, bounds of definition domain
* @param int n, number of points to draw the function
* @deprecated
*/
public void set(IyFx f, double inf, double sup, int n)
	{
	N = Math.max(2,n); 
	fromString = false;
	fonc = f;
	if ( inf > sup )
		{
		xsup = inf;
		xinf = sup;
		}
	else
		{
		xsup = sup;
		xinf = inf;
		}
	}
/**
* Sets the function, the bounds of its definition domain and the number of points to be used to draw it. 
* @param IyFx f, the function
* @param String s, the string representation of the function 
* @param double inf, sup, bounds of definition domain
* @param int n, number of points to draw the function
*/
public void set(IyFx f, String s, double inf, double sup, int n)
	{
	sf = s;
	N = Math.max(2,n); 
	fromString = false;
	fonc = f;
	if ( inf > sup )
		{
		xsup = inf;
		xinf = sup;
		}
	else
		{
		xsup = sup;
		xinf = inf;
		}
	}
/**
* Sets the limits of the defintion domain of this function.
* @param double xinf, xsup, the bounds of domain
*/
public void set(double inf, double sup)
	{
	if ( inf > sup )
		{
		xsup = inf;
		xinf = sup;
		}
	else
		{
		xsup = sup;
		xinf = inf;
		}
	}
/**
* Sets the number of points to be used to draw this function.
* @param int n, number of points
*/
public void set(int n)
	{
	N = Math.max(2,n); 
	}
	
/**
* Sets the function
* @param IyFx f, a function
* @deprecated
*/
public void set(IyFx f)
	{
	fromString = false;
	fonc = f;
	}
	
/**
* Sets the function
* @param IyFx f, a function
* @param String s, the string representation of the function
* @deprecated
*/
public void set(IyFx f, String s)
	{
	sf = s;
	fromString = false;
	fonc = f;
	}

/**
* Sets the function from its string representation. This string will be interpreted by the opale parser : see <code>opale.mathtools.parser.Parser</code to the syntax of this parser
* @param String s, the string representation of the function
* @return boolean, true if the string is correctly interpreted, false otherwise
*/
public boolean set(String s)
	{
/*	if (parser.parse(s))
		{
		boolean[] b = parser.getVariables();
		if ( b[1] || b[2] )
			return false;
		fromString = true;
		sf = s;
		return true;
		}*/
	parser = new Parser();
	parser.addVar("x");	
	parser.parseString(s);
	fromString = true;
	sf = s;
		
	return true;
	}
	
/**
* Clones this object.
* @return Object, a clone object
* @exception  OutOfMemoryError if not enough memory
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	yFx y = (yFx) super.clone();
	y.oij = oij;
	y.parser = new Parser();
	y.parser.addVar("x");
	if (fromString)
		y.parser.parseString(sf);
	return y;
	}

/**
* Changes the OIJ of this object.
* @param OIJ rep
*/
public void changeOIJ(OIJ rep)
	{
	oij=rep;
	}
	
public void writeMore(PrintWriter f, OpaleSet p) throws InvalidFormatException
	{
	int i;
	f.println("N "+N);
	f.println("Xinf "+xinf);
	f.println("Xsup "+xsup);
	f.println("f(x)=  '"+sf+"'");
	
	}	


	
public  int readKeyWord(String word, StreamReader f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	int type,i;
	if ( word.equals("N"))
		{
		N = (int) f.nextDouble();
		return 0;
		}
	else if ( word.equals("f(x)="))
		{
		String sval = f.next();
	//System.out.println("mot = " + f.sval);
		if (!( sval.endsWith("'") && sval.startsWith("'")))  throw new InvalidFormatException("Erreur  la lecture de la fonction  tracer : "+sval+". La fonction  tracer doit etre indiqu entre guillemets");
		String s = sval.substring(1,sval.length()-1);
		if ( !set(s) ) throw new InvalidFormatException("Erreur  la lecture de la fonction  tracer : "+s);
		return 0;
		}
	else if ( word.equals("Xinf"))
		{
		xinf = f.nextDouble();
		return 0;
		}
	else if ( word.equals("Xsup"))
		{
		xsup = f.nextDouble();
		return 0;
		}
	return -1;
		
	}


/**
* Returns the minimum bound of definition domain.
* @double
* @since Opale-2d 0.17
*/
public double getXINF() { return xinf; }

/**
* Returns the maximum bound of definition domain.
* @double
* @since Opale-2d 0.17
*/
public double getXSUP() { return xsup; }

/**
* Return string representation of the function
* @String
* @since Opale-2d 0.17
*/
public String getString() { return sf; }

/**
* Return number of points used  for the drawing
* @int
* @since Opale-2d 0.17
*/
public int getPrecision() { return N ; }


	
public String toString()
	{
	String s="f(x) = "+sf;
	return s;
	}
	
public static void main(String[] arg)
	{
	OIJ rep = new OIJ();
	yFx f = new yFx(rep);
	try
	{
	OIJ rep2 = new OIJ(rep,1,0,1,0,0,1);
	f.changeOIJ(rep2);
	f.set(new IyFx() { public double val(double x) {return (x-1)*(x-1);}},"(x-1)*(x-1)");
	System.err.println(f.val(0));
	System.err.println(0.01-0.1*0.1);
	}
	catch(OIJException e)
	{}
	}	
	
	
	
}
