/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d.object2d;
import opale.tools.*;
import opale.mathtools.*;
import opale.mathtools.parser.*;
import opale.m2d.*;
import java.util.Vector;
import java.io.*;
/**
* This class represents a parametric function x(t), y(t).
* @since Opale-2d 0.11
* @author O.C.
*/

public class xyFt extends Object2D implements Cloneable
{
protected IxyFt fonc;
private String str_x="",str_y="";
private boolean fromString=false;
protected double tinf, tsup;
protected int N;
private Parser parserx,parsery;


/**
* Default constructor.
*/
public xyFt()
	{
	super();
	if (Debug.On) Debug.print("Dans xyFt()");
	N=100;
	tinf =0;
	tsup = 10;
	//parserx = new Parser();
	//parserx.addVar("t");
	//parsery = new Parser();
	//parsery.addVar("t");
        fonc = 	new IxyFt() 
				{ 
				public double x(double t) { return 0;}; 
				public double y(double t) { return 0;}; 
				};
	}

/**
* Constructs the zero function in a specififed OIJ.  
* @param OIJ rep
*/
public xyFt(OIJ rep)
	{
	super(rep);
	N=100;
	tinf =0;
	tsup = 10;
        fonc = 	new IxyFt() 
				{ 
				public double x(double t) { return 0;}; 
				public double y(double t) { return 0;}; 
				};
	}


/**
* Constructs an instance from an existing instance of xyFt
* @param xyFt d, object to be copied
*/
public xyFt(xyFt f)
	{
	fromString = f.fromString;
	if ( fromString )
		{
		str_x = f.str_x;
		str_y = f.str_y;
	parserx = new Parser();
	parserx.addVar("t");
	parsery = new Parser();
	parsery.addVar("t");
/*		if (!parser.parse(sf))
			{
			System.err.println("Problme dans yFx(yFx f) : Ne devrait jamais arriver !!");
			System.exit(-1);
			}*/
		parserx.parseString(str_x)	;
		parsery.parseString(str_y)	;
		}
	else
		fonc=f.fonc;
	N = f.N;
	tinf=f.tinf;
	tsup=f.tsup;
	}

/**
* Sets the function, the bounds of its definition domain and the number of points to be used to draw it. 
* @param IxyFt f, the function
* @param double inf, sup, bounds of definition domain
* @param int n, number of points to draw the function
* @deprecated
*/
public void set(IxyFt f, double inf, double sup, int n)
	{
	fromString = false;
	N = Math.max(2,n); 
	fonc = f;
	if ( inf > sup )
		{
		tsup = inf;
		tinf = sup;
		}
	else
		{
		tsup = sup;
		tinf = inf;
		}
	}
	

/**
* Sets the function from its strings representation. The strings will be interpreted by the opale parser : see <code>opale.mathtools.parser.Parser</code to the syntax of this parser
* @param String sx, the string representation of the function x(t)
* @param String sy, the string representation of the function y(t)
* @return boolean, true if the strings is correctly interpreted, false otherwise
*/
public boolean set(String sx, String sy)
	{
/*	if (parser.parse(s))
		{
		boolean[] b = parser.getVariables();
		if ( b[1] || b[2] )
			return false;
		fromString = true;
		sf = s;
		return true;
		}*/
	parserx = new Parser();
	parserx.addVar("t");
	parsery = new Parser();
	parsery.addVar("t");
	
	parserx.parseString(sx);
	parsery.parseString(sy);
	fromString = true;
	str_x = sx;
	str_y = sy;
	
	return true;
	}

/**
* Returns the value of the function in a specified point.
* @aparam double x, point to be computed
*/
public double[] val(double t)
	{
	double[] resu = new double[2];	
	if ( fromString)
		{
		try
		{
		//double resu = parser.getResult(x);
		parserx.setVar("t",t);
		parsery.setVar("t",t);
		resu[0] = parserx.eval();
		resu[1] = parsery.eval();
		}
		catch (Exception e)
		{
		System.err.println(e);
		System.err.println("Ne devrait jamais arriver");
		}
		}
	else
		{
		resu[0] =  fonc.x(t);
		resu[1] =  fonc.y(t);
		}
	return resu;
	}



/**
* Clones this object.
* @return Object, a clone object
* @exception  OutOfMemoryError if not enough memory
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	xyFt y = (xyFt) super.clone();
	return y;
	}

/**
* Changes the OIJ of this object.
* @param OIJ rep
*/
public void changeOIJ(OIJ rep)
	{
	}
	
public void writeMore(PrintWriter f, OpaleSet p) throws InvalidFormatException
	{
	int i;
	f.println("N "+N);
	f.println("Tmin "+tinf);
	f.println("Tmax "+tsup);
	f.println("x(t)=  '"+str_x+"'");
	f.println("y(t)=  '"+str_y+"'");
	}	
	

	
public  int readKeyWord(String word, StreamReader f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	int type,i;
	if ( word.equals("N"))
		{
		N = (int) f.nextDouble();
		return 0;
		}
	else if ( word.equals("x(t)="))
		{
		String sval = f.next();
		if (!( sval.endsWith("'") && sval.startsWith("'")))  throw new InvalidFormatException("Erreur  la lecture de la fonction  tracer : "+sval+". La fonction  tracer doit etre indiqu entre guillemets");
		String s = sval.substring(1,sval.length()-1);
		str_x = s;
		parserx = new Parser();
		parserx.addVar("t");
	
		parserx.parseString(s);
		fromString = true;
		return 0;
		}
	else if ( word.equals("y(t)="))
		{
		String sval = f.next();
	//System.out.println("mot = " + f.sval);
		if (!( sval.endsWith("'") && sval.startsWith("'")))  throw new InvalidFormatException("Erreur  la lecture de la fonction  tracer : "+sval+". La fonction  tracer doit etre indiqu entre guillemets");
		String s = sval.substring(1,sval.length()-1);
		str_y = s;
		parsery = new Parser();
		parsery.addVar("t");
		parsery.parseString(s);
		fromString = true;
		return 0;
		}
	else if ( word.equals("Tmin"))
		{
		tinf = f.nextDouble();
		return 0;
		}
	else if ( word.equals("Tmax"))
		{
		tsup = f.nextDouble();
		return 0;
		}
	return -1;
		
	}
	
public String toString()
	{
	String s="(x(t) ; y(t)) = ("+str_x+" ; "+str_y+")";
	return s;
	}

/**
* Returns the minimum bound of definition domain.
* @double
* @since Opale-2d 0.17
*/
public double getTmin() { return tinf; }

/**
* Returns the maximum bound of definition domain.
* @double
* @since Opale-2d 0.17
*/
public double getTmax() { return tsup; }

/**
* Set the bounds  of definition domain.
* @param double, double
* @since Opale-2d 0.17
*/
public void setBounds(double t0, double t1)
{
if ( t0 > t1 )
	{
	tsup = t0;
	tinf = t1;
	}
else
	{
	tsup = t1;
	tinf = t0;
	}
}

/**
* Return string representation of the function x(t)
* @String
* @since Opale-2d 0.17
*/
public String getStringX() { return str_x; }

/**
* Return string representation of the function y(t)
* @String
* @since Opale-2d 0.17
*/
public String getStringY() { return str_y; }

/**
* Return number of points used  for the drawing
* @return int
* @since Opale-2d 0.17
*/
public int getPrecision() { return N ; }

/**
* Set number of points used  for the drawing
* @param int
* @since Opale-2d 0.17
*/
public void setPrecision(int n) {  N = Math.max(2,n); }

	
}
