/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d.object2d;
import opale.m2d.*;
import opale.m2d.marktype.*;
import opale.tools.*;
import opale.mathtools.*;
import java.io.*;

/**
*This class extends <code>yFx</code> and implements GObject2D. It makes it possible to draw a cartesian function.
* @since Opale-2d 0.1
* @author O.C.
*/

public class GyFx extends yFx implements Cloneable, GObject2D
{
private DefaultGraphicalOptions info; 
private boolean maxdraw=false;


/**
* Defautl constructor. Call to <code>yFx()</code>
*/
public GyFx()
	{
	super();
	if (Debug.On) Debug.print("Dans GyFx()");
	info = new DefaultGraphicalOptions();
	}

/**
* Constructs a funtion by default (zero function!) and with graphical properties by default. 
* @param OIJ rep.
*/
public GyFx(OIJ rep)
	{
	super(rep);
	info = new DefaultGraphicalOptions();
	}


/**
* Copy constructor.
* @param GyFx d, object to be copied.
*/
public GyFx(GyFx f)
	{
	super(f);	
	info = f.info;
	maxdraw = f.maxdraw;
	}

public void draw(Pen2D c)
	{

	double[] x = new double[N];
	double[] y = new double[N];
	int i;
	double sup, inf;
	
	if (maxdraw)
		{
		sup = c.getCoordSyst().getXmax();
		inf = c.getCoordSyst().getXmin();
		}
	else 
		{
		sup = xsup;
		inf = xinf;
		}
	double pas = Math.abs(sup-inf)/(N-1);
	
	for (i=0;i<N;i++)
		{
		x[i] = inf + i*pas;
		y[i] = val(x[i]);
		}
	if ( info.isVisible())
		{
		c.setColor(info.getColor());
			for (i=0;i<N-1;i++)
				c.drawLine(x[i],y[i],x[i+1],y[i+1]);
		MarkType mt = info.getMarktype();
		if (!(mt instanceof ClassicPoint))
		 for (i=0;i<N;i++)
			 mt.draw(c,x[i],y[i]);
		}



	}
	
	
/**
* Sets a flag to indicate if one wants to draw the function in all the coordinate system or only in its definition domain.
* @param boolean, true to draw in the entire part of the coordinate system
* @since Opale-2d 0.11
*/
public void maxdraw(boolean b)
	{
	maxdraw = b;
	}
	
public InfoObject getInfo()
	{
	return info;
	}

	
public  int readKeyWord(String word, StreamReader f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	if ( word.equals("INFO"))
		{
		info.read(f,p);
		return 0;
		}
	else if ( word.equals("maxdraw"))
		{
		maxdraw = true;
		return 0;
		}
	else return super.readKeyWord(word,f,p);
	}

public void writeMore(PrintWriter f, OpaleSet p) throws InvalidFormatException
	{
	info.write(f,p);
	if (maxdraw)
		f.println("maxdraw");
	super.writeMore(f,p);
	}	

	
/**
* Clones this object.
* @return Object, a clone
* @exception  OutOfMemoryError if not enough memory
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	GyFx gy = (GyFx) super.clone();
	return gy;
	}
public double x(double t) { return t; }
public double y(double t) {  return val(t); }

}
