/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d.object2d;
import java.io.*;
import opale.m2d.*;
import opale.m2d.marktype.*;
import opale.tools.*;
import opale.mathtools.*;

/**
* Cette classe tend <code>xyFt</code> et reprsente graphiquemnet une fonction paramtrique x(t), y(t)..
* @since Opale-2d 0.11
* @author O.C.
*/

public class GxyFt extends xyFt implements Cloneable, GObject2D
{
private DefaultGraphicalOptions info; 

/**
* Constructeur par dfaut.
*/
public GxyFt()
	{
	super();
	if (Debug.On) Debug.print("Dans GxyFt()");
	info = new DefaultGraphicalOptions();
	}

/**
* Construit et initialise le nuage avec 0 points et avec les informations par dfaut.  
* @param OIJ rep, le repre.
*/
public GxyFt(OIJ rep)
	{
	super(rep);
	info = new DefaultGraphicalOptions();
	}


/**
* Le constructeur de copie
* @param GData d, l'objet  copier.
*/
public GxyFt(GxyFt f)
	{
	super(f);
	this.tinf = f.tinf;
	this.tsup = f.tsup;
	N = f.N;
	info = f.info;
	
	}


public void draw(Pen2D c)
	{

	double[] x = new double[N];
	double[] y = new double[N];
	int i;
	double pas = Math.abs(tsup-tinf)/(N-1),t;
	double[] tmp;
	for (i=0;i<N;i++)
		{
		t =tinf + i*pas;
		tmp =  val(t);
		x[i] = tmp[0];
		y[i] = tmp[1];
		}
	if ( info.isVisible())
		{
		c.setColor(info.getColor());
			for (i=0;i<N-1;i++)
				c.drawLine(x[i],y[i],x[i+1],y[i+1]);
		MarkType mt = info.getMarktype();
		if (!(mt instanceof ClassicPoint))
			for (i=0;i<N;i++)
				mt.draw(c,x[i],y[i]);
		}



	}
	
public InfoObject getInfo()
	{
	return info;
	}
	
	
public int readKeyWord(String word, StreamReader f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	if ( word.equals("INFO"))
		{
		info.read(f,p);
		return 0;
		}
	else return super.readKeyWord(word,f,p);
	}

public void writeMore(PrintWriter f, OpaleSet p) throws InvalidFormatException
	{
	info.write(f,p);
	super.writeMore(f,p);
	}	

	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	GxyFt gy = (GxyFt) super.clone();
	return gy;
	}

public double x(double t) { return val(t)[0]; }
public double y(double t) {  return val(t)[1]; }
}
