/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d.object2d;
import opale.tools.*;
import opale.mathtools.*;
import opale.mathtools.parser.*;
import opale.m2d.*;
import java.util.Vector;
import java.io.*;
/**
* Cette classe reprsente une fonction polaire r =f(theta) avec theta en radians.
* @since Opale-2d 0.11
* @author O.C.
*/

public class FPolar extends Object2D implements Cloneable
{
private IyFx fonc;
private String sf="";
private boolean fromString=false;
private Parser parser;
private OIJ oij;
protected double tinf, tsup;
protected int N;

/**
* Constructeur par dfaut.
*/
public FPolar()
	{
	super();
	oij=new OIJ();
	if (Debug.On) Debug.print("Dans FPolar()");
	parser = new Parser();
	parser.addVar("t");
	N=100;
	tinf =0;
	tsup = 6.28;
        fonc = new IyFx() { public double val(double x) {return 0;}};	
	}

/**
* Construit et initialise le nuage avec 0 points et avec les informations par dfaut.  
* @param OIJ rep, le repre.
*/
public FPolar(OIJ rep)
	{
	super(rep);
	oij =  rep;
	parser = new Parser();
	parser.addVar("t");
	N=100;
	tinf =0;
	tsup = 6.28;
        fonc = new IyFx() { public double val(double x) {return 0;}};	
	}


/**
* Le constructeur de copie
* @param FPolar d, l'objet  copier.
*/
public FPolar(FPolar f)
	{
        super(f.getOIJ());
	oij = f.oij;
	fromString = f.fromString;
	if ( fromString )
		{
		sf = f.sf;
		parser = new Parser();
		parser.addVar("t");
/*		if (!parser.parse(sf))
			{
			System.err.println("Problme dans FPolar(FPolar f) : Ne devrait jamais arriver !!");
			System.err.println("Contactez l'quipe opale par  email cioni@eleves.enpc.fr en prcisant les circonstances d'apparition du bug.");
			System.exit(-1);
			}*/
		parser.parseString(sf);
		}
	else
		fonc=f.fonc;
	N = f.N;
	tinf=f.tinf;
	tsup=f.tsup;
	}

/**
* Renvoie la valeur de la fonction r(x) en un point.
* @aparam double x, le point  calculer.
*/
public double val(double x)
	{
	Matrix2D mv = new Matrix2D();
	oij.matPassage(getOIJ(),mv);
	double[] p = mv.compute(x,0);
	x = p[0];
	if ( fromString)
		{
		try
		{
		parser.setVar("t",x);
		double resu = parser.eval();
		getOIJ().matPassage(oij,mv);
		p = mv.compute(x,resu);
		return p[1];
		}
		catch (Exception e)
		{
		System.err.println(e);
		System.err.println("Ne devrait jamais arriver");
		}
		return 0;
		}
	else
		{
		double resu = fonc.val(x);
		getOIJ().matPassage(oij,mv);
		p = mv.compute(x,resu);
		return p[1];
		}
	}

/**
* Fixe la fonction polaire  tracer, les bornes de dfinition et le nombre de points.
* @param IyFx f, la fonction  dessiner.
* @param double inf, sup, les bornes du domaine de dfinition.
* @param int n, le nombre de points  considerer sur la courbe.
* @deprecated
*/
public void set(IyFx f, double inf, double sup, int n)
	{
	N = Math.max(2,n); 
	fromString = false;
	fonc = f;
	if ( inf > sup )
		{
		tsup = inf;
		tinf = sup;
		}
	else
		{
		tsup = sup;
		tinf = inf;
		}
	}
/**
* Fixe la fonction polaire  tracer, les bornes de dfinition et le nombre de points.
* @param IyFx f, la fonction  dessiner.
* @param String s, l'expression de f sous forme de chaine de caractres.
* @param double inf, sup, les bornes du domaine de dfinition.
* @param int n, le nombre de points  considerer sur la courbe.
*/
public void set(IyFx f, String s, double inf, double sup, int n)
	{
	sf = s;
	N = Math.max(2,n); 
	fromString = false;
	fonc = f;
	if ( inf > sup )
		{
		tsup = inf;
		tinf = sup;
		}
	else
		{
		tsup = sup;
		tinf = inf;
		}
	}
/**
* Fixe les bornes de dfinition.
* @param double inf, sup, les bornes du domaine de dfinition.
*/
public void set(double inf, double sup)
	{
	if ( inf > sup )
		{
		tsup = inf;
		tinf = sup;
		}
	else
		{
		tsup = sup;
		tinf = inf;
		}
	}
/**
* Fixe le nombre de points de prcision.
* @param int n, le nombre de points.
*/
public void set(int n)
	{
	N = Math.max(2,n); 
	}
	
/**
* Fixe la fonction a tracer.
* @param IyFx f, la fonction  dessiner.
* @deprecated
*/
public void set(IyFx f)
	{
	fromString = false;
	fonc = f;
	}
	
/**
* Fixe la fonction a tracer et son expression
* @param IyFx f, la fonction  dessiner.
* @param String s, l'expression de f sous forme de chaine.
*/
public void set(IyFx f, String s)
	{
	sf = s;
	fromString = false;
	fonc = f;
	}

/**
* Fixe la fonction a tracer  partir d'une chaine de caractres.
* @param String s, la chaine de caractre reprsentant la fonction  dessiner.
* @return boolean, true si la chaine a pu etre interprt coorectement.
*/
public boolean set(String s)
	{
/*	if (parser.parse(s))
		{
		boolean[] b = parser.getVariables();
		if ( b[1] || b[2] )
			return false;
		fromString = true;
		sf = s;
		return true;
		}
	return false;*/
	parser.parseString(s);
		fromString = true;
		sf = s;
		return true;
	
	}
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	FPolar y = (FPolar) super.clone();
	y.oij = oij;
	//y.parser = new ParseFunction();
	y.parser = new Parser();
	y.parser.addVar("t");
	if (fromString)
		y.parser.parseString(sf);
	return y;
	}

/**
* Effectue un changement de repere de l'objet.
* @param OIJ rep, le nouveau repere.
*/
public void changeOIJ(OIJ rep)
	{
	oij=rep;
	}
	
public void writeMore(PrintWriter f, OpaleSet p) throws InvalidFormatException
	{
	int i;
	f.println("N "+N);
	f.println("Tmin "+tinf);
	f.println("Tmax "+tsup);
	
	f.println("r(t)=   '"+sf+"'");
	
	}	
	
	
public  int readKeyWord(String word, StreamReader f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	int i;
	if ( word.equals("N"))
		{
		N = (int) f.nextDouble();
		return 0;
		}
	else if ( word.equals("r(t)="))
		{
		String sval = f.next();
		if (!( sval.endsWith("'") && sval.startsWith("'")))  throw new InvalidFormatException("Erreur  la lecture de la fonction  tracer : "+sval+". La fonction  tracer doit etre indiqu entre guillemets");
		String s = sval.substring(1,sval.length()-1);
		if ( !set(s) ) throw new InvalidFormatException("Erreur  la lecture de la fonction  tracer : "+s);
		return 0;
		}
	else if ( word.equals("Tmin"))
		{
		tinf = f.nextDouble();
		return 0;
		}
	else if ( word.equals("Tmax"))
		{
		tsup = f.nextDouble();
		return 0;
		}
	return -1;
		
	}
	
public String toString()
	{
	String s="r(t) = "+sf;
	return s;
	}
/**
* Return t_inf
* @param double
* @since Opale-2d 0.17
*/
public double getTmin() { return tinf; }

/**
* Return t_sup
* @param double
* @since Opale-2d 0.17
*/
public double getTmax() { return tsup; }

/**
* Set the borns of definition
* @param double, double
* @since Opale-2d 0.17
*/
public void setBounds(double t0, double t1)
{
if ( t0 > t1 )
	{
	tsup = t0;
	tinf = t1;
	}
else
	{
	tsup = t1;
	tinf = t0;
	}
}

/**
* Return string representation of the function x(t)
* @String
* @since Opale-2d 0.17
*/
public String getString() { return sf; }


/**
* Return number of points used  for the drawing
* @return int
* @since Opale-2d 0.17
*/
public int getPrecision() { return N ; }

/**
* Set number of points used  for the drawing
* @param int
* @since Opale-2d 0.17
*/
public void setPrecision(int n) {  N = Math.max(2,n); }
	
public static void main(String[] arg)
	{
	OIJ rep = new OIJ();
	FPolar f = new FPolar(rep);
	try
	{
	OIJ rep2 = new OIJ(rep,1,0,1,0,0,1);
	f.changeOIJ(rep2);
	f.set(new IyFx() { public double val(double x) {return (x-1)*(x-1);}},"(x-1)*(x-1)");
	System.err.println(f.val(0));
	}
	catch(OIJException e)
	{}
	}	

}
