/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.cst.chemistry;
import java.util.*;

/** 
* This class has been automatically created by the program opale.tools.OTGC. 
*/
public class Element
{
private String name;
private String fSymbol;
private int fZ;
private int fA;
private double fMeltingPoint;

public Element() 
{
name ="";
fSymbol="";
fZ=0;
fA=0;
fMeltingPoint=0.;
}

public Element(String name, String Symbol, int Z, int A, double MeltingPoint)
{
this.name = name;
this.fSymbol=Symbol;
this.fZ=Z;
this.fA=A;
this.fMeltingPoint=MeltingPoint;
}

public String getSymbol() { return this.fSymbol;};
public int getZ() { return this.fZ;};
public int getA() { return this.fA;};
public double getMeltingPoint() { return this.fMeltingPoint;};
public String toString() { return name; }

public String toLongString()
	{
	StringBuffer s=new StringBuffer(name);
	s.append("	Symbol = " + this.fSymbol
);
	s.append("	Z = " + this.fZ
);
	s.append("	A = " + this.fA
);
	s.append("	MeltingPoint = " + this.fMeltingPoint
);
	return s.toString();
	}

}
