/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale;

/**
* This class is used to query and display information about version and developpers.
* @since Opale V1b2
* @author O.C.
* @date 14/01/2001
*/

public class Info
{
private static String version ="Opale V1b8";
private static String date ="09/2002";
private static String[] name = { 
		"Romain Pacanowski",
		"Ren Ferrro",
		"Djabir Kouzzi",
		"Jean Michel",
		"Olivier Cioni"
		};
	
/**
* Gets a string that represents the version of Opale.
* @return String, the version.
*/
public static String getVersion()
	{
	return version;
	}

/**
* Gets an array of String that represents the name of developpers.
* @return String[], the names of developpers
*/
public static String[] getDeveloppers()
	{
	return name;
	}
	
/**
* This method is used to display informations.
*/
public static void main(String[] arg)
	{
	System.out.println("***********************");
	System.out.println("**** Opale library ****");
	System.out.println("***********************");
	System.out.println("Version : " +version);
	System.out.println("Date : " +date);
	System.out.println("\nThis version was written by :");
	for (int i=0;i<name.length;i++)
		System.out.println("->> "+name[i]);
	
	System.out.println("\nPlease consult the URL http://www.opale.ovh.org for more information and to report problems.");
	System.out.println("\nThis program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.");
	}
}	
