/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.object2d;

import java.io.IOException;
import java.io.PrintWriter;
import opale.m2d.Matrix2D;
import opale.m2d.OIJ;
import opale.m2d.OIJException;
import opale.m2d.Object2D;
import opale.mathtools.IyFx;
import opale.mathtools.parser.Parser;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;
import opale.tools.StreamReader;

public class FPolar
extends Object2D
implements Cloneable {
    private IyFx fonc;
    private String sf = "";
    private boolean fromString = false;
    private Parser parser;
    private OIJ oij;
    protected double tinf;
    protected double tsup;
    protected int N;

    public FPolar() {
        this.oij = new OIJ();
        Debug.print("Dans FPolar()");
        this.parser = new Parser();
        this.parser.addVar("t");
        this.N = 100;
        this.tinf = 0.0;
        this.tsup = 6.28;
        this.fonc = new IyFx(){

            public double val(double d) {
                return 0.0;
            }
        };
    }

    public FPolar(OIJ oIJ) {
        super(oIJ);
        this.oij = oIJ;
        this.parser = new Parser();
        this.parser.addVar("t");
        this.N = 100;
        this.tinf = 0.0;
        this.tsup = 6.28;
        this.fonc = new IyFx(){

            public double val(double d) {
                return 0.0;
            }
        };
    }

    public FPolar(FPolar fPolar) {
        super(fPolar.getOIJ());
        this.oij = fPolar.oij;
        this.fromString = fPolar.fromString;
        if (this.fromString) {
            this.sf = fPolar.sf;
            this.parser = new Parser();
            this.parser.addVar("t");
            this.parser.parseString(this.sf);
        } else {
            this.fonc = fPolar.fonc;
        }
        this.N = fPolar.N;
        this.tinf = fPolar.tinf;
        this.tsup = fPolar.tsup;
    }

    public double val(double d) {
        Matrix2D matrix2D = new Matrix2D();
        this.oij.matPassage(this.getOIJ(), matrix2D);
        double[] dArray = matrix2D.compute(d, 0.0);
        d = dArray[0];
        if (this.fromString) {
            try {
                this.parser.setVar("t", d);
                double d2 = this.parser.eval();
                this.getOIJ().matPassage(this.oij, matrix2D);
                dArray = matrix2D.compute(d, d2);
                return dArray[1];
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.err.println("Ne devrait jamais arriver");
                return 0.0;
            }
        }
        double d3 = this.fonc.val(d);
        this.getOIJ().matPassage(this.oij, matrix2D);
        dArray = matrix2D.compute(d, d3);
        return dArray[1];
    }

    public void set(IyFx iyFx, double d, double d2, int n) {
        this.N = Math.max(2, n);
        this.fromString = false;
        this.fonc = iyFx;
        if (d > d2) {
            this.tsup = d;
            this.tinf = d2;
        } else {
            this.tsup = d2;
            this.tinf = d;
        }
    }

    public void set(IyFx iyFx, String string, double d, double d2, int n) {
        this.sf = string;
        this.N = Math.max(2, n);
        this.fromString = false;
        this.fonc = iyFx;
        if (d > d2) {
            this.tsup = d;
            this.tinf = d2;
        } else {
            this.tsup = d2;
            this.tinf = d;
        }
    }

    public void set(double d, double d2) {
        if (d > d2) {
            this.tsup = d;
            this.tinf = d2;
        } else {
            this.tsup = d2;
            this.tinf = d;
        }
    }

    public void set(int n) {
        this.N = Math.max(2, n);
    }

    public void set(IyFx iyFx) {
        this.fromString = false;
        this.fonc = iyFx;
    }

    public void set(IyFx iyFx, String string) {
        this.sf = string;
        this.fromString = false;
        this.fonc = iyFx;
    }

    public boolean set(String string) {
        this.parser.parseString(string);
        this.fromString = true;
        this.sf = string;
        return true;
    }

    public Object clone() {
        FPolar fPolar = (FPolar)super.clone();
        fPolar.oij = this.oij;
        fPolar.parser = new Parser();
        fPolar.parser.addVar("t");
        if (this.fromString) {
            fPolar.parser.parseString(this.sf);
        }
        return fPolar;
    }

    public void changeOIJ(OIJ oIJ) {
        this.oij = oIJ;
    }

    public void writeMore(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        printWriter.println("N " + this.N);
        printWriter.println("Tmin " + this.tinf);
        printWriter.println("Tmax " + this.tsup);
        printWriter.println("r(t)=   '" + this.sf + "'");
    }

    public int readKeyWord(String string, StreamReader streamReader, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("N")) {
            this.N = (int)streamReader.nextDouble();
            return 0;
        }
        if (string.equals("r(t)=")) {
            String string2 = streamReader.next();
            if (!string2.endsWith("'") || !string2.startsWith("'")) {
                throw new InvalidFormatException("Erreur \u00e0 la lecture de la fonction \u00e0 tracer : " + string2 + ". La fonction \u00e0 tracer doit etre indiqu\u00e9 entre guillemets");
            }
            String string3 = string2.substring(1, string2.length() - 1);
            if (!this.set(string3)) {
                throw new InvalidFormatException("Erreur \u00e0 la lecture de la fonction \u00e0 tracer : " + string3);
            }
            return 0;
        }
        if (string.equals("Tmin")) {
            this.tinf = streamReader.nextDouble();
            return 0;
        }
        if (string.equals("Tmax")) {
            this.tsup = streamReader.nextDouble();
            return 0;
        }
        return -1;
    }

    public String toString() {
        String string = "r(t) = " + this.sf;
        return string;
    }

    public double getTmin() {
        return this.tinf;
    }

    public double getTmax() {
        return this.tsup;
    }

    public void setBounds(double d, double d2) {
        if (d > d2) {
            this.tsup = d;
            this.tinf = d2;
        } else {
            this.tsup = d2;
            this.tinf = d;
        }
    }

    public String getString() {
        return this.sf;
    }

    public int getPrecision() {
        return this.N;
    }

    public void setPrecision(int n) {
        this.N = Math.max(2, n);
    }

    public static void main(String[] stringArray) {
        OIJ oIJ = new OIJ();
        FPolar fPolar = new FPolar(oIJ);
        try {
            OIJ oIJ2 = new OIJ(oIJ, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0);
            fPolar.changeOIJ(oIJ2);
            fPolar.set(new IyFx(){

                public double val(double d) {
                    return (d - 1.0) * (d - 1.0);
                }
            }, "(x-1)*(x-1)");
            System.err.println(fPolar.val(0.0));
        }
        catch (OIJException oIJException) {
            // empty catch block
        }
    }
}

