/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.component2d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import opale.m2d.AffineTransform2D;
import opale.m2d.component2d.AffineTransform2DEditor;
import opale.swools.MathExprTextField;

public class TranslationTransformEditor
extends JFrame {
    private AffineTransform2D afft;
    private AffineTransform2DEditor afftEditor;
    private boolean set;
    private Font font = new Font("Monospaced", 1, 12);
    private JButton okButton = new JButton();
    private JButton appButton = new JButton();
    private JButton closeButton = new JButton();
    private BorderLayout layoutFond = new BorderLayout();
    private BorderLayout layoutPanneaufond = new BorderLayout();
    private GridLayout layoutOption = new GridLayout(2, 1);
    private JPanel panneauFond = new JPanel();
    private JPanel panneauBouton = new JPanel();
    private JPanel panneauOption = new JPanel();
    private MathExprTextField tx = new MathExprTextField(10);
    private MathExprTextField ty = new MathExprTextField(10);
    private JLabel labtx = new JLabel("tx");
    private JLabel labty = new JLabel("ty");

    public TranslationTransformEditor(boolean bl, AffineTransform2D affineTransform2D) {
        this.set = bl;
        this.afftEditor = null;
        if (affineTransform2D == null) {
            affineTransform2D = new AffineTransform2D();
        }
        this.afft = affineTransform2D;
        try {
            this.oInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TranslationTransformEditor(AffineTransform2DEditor affineTransform2DEditor, boolean bl, AffineTransform2D affineTransform2D) {
        this.afftEditor = affineTransform2DEditor;
        this.set = bl;
        if (affineTransform2D == null) {
            affineTransform2D = new AffineTransform2D();
        }
        this.afft = affineTransform2D;
        try {
            this.oInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void oInit() throws Exception {
        ((Component)this).setSize(new Dimension(300, 150));
        this.setResizable(true);
        this.setTitle("Translation Transform 2D Editor");
        this.getContentPane().setLayout(this.layoutFond);
        this.panneauFond.setLayout(this.layoutPanneaufond);
        this.panneauOption.setLayout(this.layoutOption);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslationTransformEditor.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.appButton.setText("Apply");
        this.appButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslationTransformEditor.this.appButton_actionPerformed(actionEvent);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslationTransformEditor.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.panneauFond, "Center");
        this.panneauFond.add((Component)this.panneauBouton, "South");
        this.panneauFond.add((Component)this.panneauOption, "Center");
        JPanel jPanel = new JPanel();
        this.labtx.setFont(this.font);
        jPanel.add(this.labtx);
        jPanel.add(this.tx);
        this.panneauOption.add(jPanel);
        jPanel = new JPanel();
        this.labty.setFont(this.font);
        jPanel.add(this.labty);
        jPanel.add(this.ty);
        this.panneauOption.add(jPanel);
        this.panneauBouton.add((Component)this.okButton, null);
        this.panneauBouton.add((Component)this.appButton, null);
        this.panneauBouton.add((Component)this.closeButton, null);
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.tx.isValid()) {
            d = this.tx.getValue();
        }
        if (this.ty.isValid()) {
            d2 = this.ty.getValue();
        }
        if (this.set) {
            this.afft.setToTranslation(d, d2);
        } else {
            this.afft.translate(d, d2);
        }
        if (this.afftEditor != null) {
            this.afftEditor.updateField();
        }
        this.dispose();
    }

    void appButton_actionPerformed(ActionEvent actionEvent) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.tx.isValid()) {
            d = this.tx.getValue();
        }
        if (this.ty.isValid()) {
            d2 = this.ty.getValue();
        }
        if (this.set) {
            System.out.println("x,y" + d + " " + d2);
            this.afft.setToTranslation(d, d2);
        } else {
            this.afft.translate(d, d2);
        }
        if (this.afftEditor != null) {
            this.afftEditor.updateField();
        }
    }

    void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

