/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.tools.*;
import opale.mathtools.*;
import opale.ode.*;
import opale.ode.scheme.*;
import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.m2d.component2d.*;


public class Lorenz
	{
	
	public static void main(String[] arg)
	{
	// Rsolution de l attracteur de Lorenz 5 conditions initiales proches

	Problem pb = new Problem(3);	//problme en dimension 3
	//ExplicitEuler ts = new ExplicitEuler();
	RK ts = new RK();
		
	DVect cd = new DVect(3);	// vecteur pour la condition initiale
	
	ts.setNstep(1000);		//nombre de pas en temps : 1000
	ts.set(0,10);			// tude sur l'intervalle en temps (0;10)
	pb.setEqn(			//on dfinit l'equation du systme 
		new Equation()
			{
			final double s = 10., r=50, b=1;
			DVect y = new DVect(3);
			public int dim() { return 3; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,s*(x.get(1)-x.get(0)));		//x'(t,x,y) = y-x
				y.set(1,-x.get(0)*x.get(2)+r*x.get(0)-x.get(1));				//y'(t,x,y) = -xz+x-y
				y.set(2,x.get(0)*x.get(1)-b*x.get(2));				//y'(t,x,y) = xy-z
				return y;
				}
			}
		);

	pb.setTS(ts);	//on associe le schma en temps
	
	// on rsoud le systme de Lorenz avec les 5 conditions initiales diffrentes 
	double[][][] sol = new double[5][4][1000];
	int i;
	for (i=0;i<5;i++)
		{
		cd.set(0,-2.);
		cd.set(1,-2.);
		cd.set(2,6.+1./(i+1));
		pb.setInit(cd);
		pb.solve();
		sol[i]=pb.toArray();
		}
		
		
	// A chaque fois, la solution du problme i est stocke dans la variable sol[i]
	
	
	
	// On affiche le rsultat avec le module 2d d'Opale
	JFrame2D jf = new JFrame2D();
	jf.setTitle("Attracteur de Lorenz");
	jf.setSize(600,600);
	jf.getAxis().drawScale(false);
	OIJ repere = new OIJ();
	jf.getCS().set(-30,30,0,100);
	jf.getPack2D().add(repere,"repere");
	GData2D[] gsol = new GData2D[5];
	//chaque solution est reprsente par un objet de type GData2D (nuage de points)
	
	
	//affichage des 5 solutions
	for (i=0;i<5;i++)
		{
		gsol[i] = new GData2D(repere);
		gsol[i].getInfo().setColor(new java.awt.Color((int) (255*Math.random()),(int) (255*Math.random()),(int) (255*Math.random())));
		gsol[i].set(1000,sol[i][1],sol[i][3]);
		jf.getPack2D().add(gsol[i],"sol"+i);
		}
	jf.show();
	
	
	
	}

}
