/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package otests.mathtools.Integration;

import opale.mathtools.*;
import opale.tools.*;

public class Integration implements OTest
{
public void run(String path)
	{
	AnalyticalFunction f = new AnalyticalFunction();
	f.setFunc("x*x");
	
	RectangleRule rect = new RectangleRule();
	TrapezoidalRule trap = new TrapezoidalRule();
	
	Stdio.println("f(x)=x*x");
	Stdio.println("Rectangle rule : "+rect.integrate(f,0,1,500));
	Stdio.println("Trapezoidal rule : "+trap.integrate(f,0,1,100) + " NITER = " + trap.NITER);
	
	
	}	
public void stop() {};
}
