/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package otests.m2d.Transform2D;
import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.m2d.component2d.*;
import opale.m2d.marktype.*;
import opale.mathtools.*;
import opale.tools.*;
import java.awt.*;
import java.awt.event.*;

	
public class Transform2D extends JFrame2D implements OTest
	{
	GPoint2D p,pp,p2,pp2; 
	
	public  void run(String path)
		{
		try {
		OIJ repere = new OIJ(0,0,1,0,1,1);
		OIJ repere2 = new OIJ(1,2,1,0,0,1);
		
		System.out.println(repere.toLongString());
		
		getAxis().drawScale(false);
		//getCS().setOIJ(repere);
		getCS().normadjust();
		
		p = new GPoint2D(repere,1,0);
		p2 = new GPoint2D(repere2,1,3);

		DefaultGraphicalOptions info = (DefaultGraphicalOptions) p.getInfo();
		info.setColor(Color.red);
		DefaultGraphicalOptions info2 = (DefaultGraphicalOptions) p2.getInfo();
		info2.setColor(Color.blue);

		DiamondPoint dp = new DiamondPoint();
		dp.setMarksize(5);
		info.setMarktype(dp);
		info2.setMarktype(dp);



		AffineTransform2D t = new AffineTransform2D();
		t.rotate(Math.PI/2,0,0); // one rotation
	//	t.translate(3,-2); // one translation
		//t.scale(1.5,0.5); // one scaling
		
		pp = new GPoint2D(p);
		pp2 = new GPoint2D(p2);
		pp.transform(t);
		pp2.transform(t);
		getPack2D().add(repere,"repere");
		getPack2D().add(repere2,"repere2");
		getPack2D().add(p,"A");
		getPack2D().add(p2,"B");
		getPack2D().add(pp,"A'");
		getPack2D().add(pp2,"B'");
		getPack2D().add(t,"transf");


		WFile f= new WFile(path+"wf.txt");
		getPack2D().write(f);
		f.close();
		
		StreamReader fr = new StreamReader(path+"wf.txt");
		Pack2D pack = new Pack2D();
		pack.read(fr);
		AffineTransform2D tt = (AffineTransform2D) pack.getObject("transf");
		System.out.println("avant change oij"+tt);
		tt.changeOIJ((OIJ) pack.getObject("repere"));
		System.out.println("apres change oij"+tt);
		f.close();
		}
		catch (opale.m2d.OIJException e)
		{
		}
		catch (	java.io.IOException e)
		{
		System.out.println(e);
		System.exit(-1);
		}
		catch (InvalidFormatException e)
		{
		System.out.println(e);
		System.exit(-1);
		}
		
		
		}
		
public void stop()
	{
	dispose();
	}


	
	
	}
