/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.ode;

import opale.tools.*;
import java.util.*;
import java.io.*;

/**
* Cette classe encapsule des problmes d'ODE  dans le sens o elle contient des rfrences  des instances de type Equation, des instances de type TimeScheme et des instance de type Problem. De plus elle attribue  chacune de ces instances des identifiacteurs (sous forme de String) et elle permet de sauvegarder ou de relire des fichiers de donnes contenant la description de problmes (voir la documentation pour la structure, l'utilisation et la conception de fichiers de donnes).
* @author O.C.
* @since Opale-ODE 0.1
*/

public class ODE extends OpaleSet
{



public ODE()
	{
	super();
	}

/**
* Solve all problems in this object <code>ODE</code>.
*/
public void solve()
	{
	int i;
	Problem pb;
	OpaleObject obj;
	Collection col = objects();
	Iterator it = col.iterator();
	while (it.hasNext())
		{
		obj = (OpaleObject) it.next();
		if (obj instanceof Problem)
		
			{
			pb = (Problem) obj;
			pb.solve();
			}
		}
	}
	

}
