/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.m2d.component2d;

/**
 * Description : Scale Editor associated with JFrame2D <p>
 * @version 1.0
 * @deprecated, @see ScaleEditor2
 */

import opale.swools.*;
import opale.m2d.*;
import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;
import java.awt.event.*;


class ScaleEditor extends JFrame  implements ActionListener {

private JFrame2D mere;
private OIJListBeans oijChoice;
  JPanel jPanel1 = new JPanel();
  BorderLayout borderLayout1 = new BorderLayout();
  JPanel jPanel2 = new JPanel();
  FlowLayout flowLayout1 = new FlowLayout();
  JButton okButton = new JButton();
  JButton annulerButton = new JButton();
  TitledBorder titledBorder1;
  JButton appButton = new JButton();
  TitledBorder titledBorder2;
  TitledBorder titledBorder3;
  TitledBorder titledBorder4;
  Border border1;
  JPanel jPanel3 = new JPanel();
  JPanel jPanel4 = new JPanel();
  GridLayout gridLayout1 = new GridLayout();
  FlowLayout flowLayout2 = new FlowLayout();
  JPanel jPanel5 = new JPanel();
  JPanel jPanel6 = new JPanel();
  JPanel jPanel7 = new JPanel();
  JPanel jPanel8 = new JPanel();
  FlowLayout flowLayout4 = new FlowLayout();
  FlowLayout flowLayout5 = new FlowLayout();
  FlowLayout flowLayout6 = new FlowLayout();
  JLabel xminlabel = new JLabel();
  DoubleTextField xminField;
  JLabel xmaxlabel = new JLabel();
  DoubleTextField xmaxField;
  JLabel yminlabel = new JLabel();
  DoubleTextField yminField;
  JLabel ymaxlabel = new JLabel();
  DoubleTextField ymaxField;
  FlowLayout flowLayout3 = new FlowLayout();

  boolean oijselect = true;

  public ScaleEditor(JFrame2D mere) {
    this.mere = mere;
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  public ScaleEditor(JFrame2D mere, boolean oij) {
    oijselect = oij;
    this.mere = mere;
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    this.setSize(new Dimension(285, 155));
    setResizable(false);
    setTitle("Scale");
    titledBorder1 = new TitledBorder("");
    titledBorder2 = new TitledBorder("");
    titledBorder3 = new TitledBorder("");
    titledBorder4 = new TitledBorder("");
    border1 = BorderFactory.createEmptyBorder();
    jPanel1.setLayout(borderLayout1);
    jPanel2.setLayout(flowLayout1);
    okButton.setActionCommand("Ok");
    okButton.setText("Ok");
    okButton.addActionListener(this);
    annulerButton.setActionCommand("Cancel");
    annulerButton.setText("Cancel");
    annulerButton.addActionListener(this);
    appButton.setText("Apply");
    appButton.addActionListener(this);
    jPanel4.setLayout(gridLayout1);
    jPanel3.setLayout(flowLayout2);
    
    gridLayout1.setColumns(1);
    gridLayout1.setRows(4);
    jPanel6.setLayout(flowLayout4);
    jPanel7.setLayout(flowLayout5);
    jPanel8.setLayout(flowLayout6);

    xminField = new DoubleTextField(mere.getCS().getXmin(),10);
    xmaxField = new DoubleTextField(mere.getCS().getXmax(),10);
    yminField = new DoubleTextField(mere.getCS().getYmin(),10);
    ymaxField = new DoubleTextField(mere.getCS().getYmax(),10);

    xminlabel.setFont(new java.awt.Font("Monospaced", 1, 12));
    xminlabel.setText("xmin = ");
    xmaxlabel.setFont(new java.awt.Font("Monospaced", 1, 12));
    xmaxlabel.setText("xmax = ");
    xmaxField.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        xmaxField_actionPerformed(e);
      }
    });
    yminlabel.setFont(new java.awt.Font("Monospaced", 1, 12));
    yminlabel.setText("ymin = ");
    ymaxlabel.setFont(new java.awt.Font("Monospaced", 1, 12));
    ymaxlabel.setText("ymax = ");
    ymaxField.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        ymaxField_actionPerformed(e);
      }
    });
    jPanel5.setLayout(flowLayout3);
    this.getContentPane().add(jPanel1, BorderLayout.CENTER);
    jPanel1.add(jPanel2, BorderLayout.SOUTH);
    jPanel2.add(okButton, null);
    jPanel2.add(appButton, null);
    jPanel2.add(annulerButton, null);
    if (oijselect) 
    	{oijChoice = new OIJListBeans(mere.getPack2D());
    	jPanel1.add(oijChoice, BorderLayout.NORTH);
    	oijChoice.setSelection(mere.getCS().getOIJ());
	}
    jPanel1.add(jPanel4, BorderLayout.CENTER);
    jPanel4.add(jPanel5, null);
    jPanel5.add(xminlabel, null);
    jPanel5.add(xminField, null);
    jPanel4.add(jPanel6, null);
    jPanel6.add(xmaxlabel, null);
    jPanel6.add(xmaxField, null);
    jPanel4.add(jPanel7, null);
    jPanel7.add(yminlabel, null);
    jPanel7.add(yminField, null);
    jPanel4.add(jPanel8, null);
    jPanel8.add(ymaxlabel, null);
    jPanel8.add(ymaxField, null);
  }

  void appButton_actionPerformed(ActionEvent e) {

  }

  void xmaxField_actionPerformed(ActionEvent e) {

  }

  void ymaxField_actionPerformed(ActionEvent e) {

  }
  
public void actionPerformed(ActionEvent evt)
{
if (evt.getSource() == okButton)
  {
  CoordSystem cs = mere.getCS();
  cs.setXmin(xminField.getValue());
  cs.setXmax(xmaxField.getValue());
  cs.setYmin(yminField.getValue());
  cs.setYmax(ymaxField.getValue()); 
  if (oijselect) cs.setOIJ(oijChoice.getSelection());
  cs.autoadjust();
  mere.repaint();
  dispose();
  }
 else if (evt.getSource() == appButton)
 {
  CoordSystem cs = mere.getCS();
  cs.setXmin(xminField.getValue());
  cs.setXmax(xmaxField.getValue());
  cs.setYmin(yminField.getValue());
  cs.setYmax(ymaxField.getValue()); 
  if (oijselect) cs.setOIJ(oijChoice.getSelection());
  cs.autoadjust();
  mere.repaint();
 } 
 else if (evt.getSource() == annulerButton)
 {
 dispose();
 }
}
}
