/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.m2d.component2d;

/**
 * @version 1.0
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import opale.swools.*;
import opale.m2d.*;




public class RotationTransformEditor extends JFrame 
{
private AffineTransform2D afft;
private AffineTransform2DEditor afftEditor;
private boolean set;


private Font font = new Font("Monospaced", 1, 12);
private   JButton okButton = new JButton();
private   JButton appButton = new JButton();
private   JButton closeButton = new JButton();


private   BorderLayout layoutFond = new BorderLayout();
private   BorderLayout layoutPanneaufond = new BorderLayout();
private   GridLayout layoutOption = new GridLayout(3,1);
private   JPanel panneauFond = new JPanel();
private   JPanel panneauBouton = new JPanel();
private   JPanel panneauOption = new JPanel();
private MathExprTextField cx = new MathExprTextField(10);
private MathExprTextField cy = new MathExprTextField(10);
private MathExprTextField theta = new MathExprTextField(10);
private JLabel labcx = new JLabel("   cx");
private JLabel labcy = new JLabel("   cy");
private JLabel labThe = new JLabel("theta");

public RotationTransformEditor(boolean set, AffineTransform2D at)
{
super();
this.set = set;
afftEditor = null;
if (at == null)
	at = new AffineTransform2D();
afft = at;
  try {
    oInit();
  }
  catch(Exception e) {
    e.printStackTrace();
  }
}


public RotationTransformEditor(AffineTransform2DEditor ed, boolean set, AffineTransform2D at)
{
super();
afftEditor = ed;
this.set = set;
if (at == null)
	at = new AffineTransform2D();
afft = at;
  try {
    oInit();
  }
  catch(Exception e) {
    e.printStackTrace();
  }
}

private void oInit() throws Exception {
  this.setSize(new Dimension(300, 150));
  setResizable(true);
  setTitle("Scaling Transform 2D Editor");
  this.getContentPane().setLayout(layoutFond);
  panneauFond.setLayout(layoutPanneaufond);
  panneauOption.setLayout(layoutOption);
  

// Les boutons ok, apply & close
  okButton.setText("Ok");
  okButton.addActionListener(new java.awt.event.ActionListener() {

    public void actionPerformed(ActionEvent e) {
      okButton_actionPerformed(e);
    }
  });
  appButton.setText("Apply");
  appButton.addActionListener(new java.awt.event.ActionListener() {

    public void actionPerformed(ActionEvent e) {
      appButton_actionPerformed(e);
    }
  });
  closeButton.setText("Close");
  closeButton.addActionListener(new java.awt.event.ActionListener() {

    public void actionPerformed(ActionEvent e) {
      closeButton_actionPerformed(e);
    }
  });
  
  


  this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
  this.getContentPane().add(panneauFond, BorderLayout.CENTER);

  panneauFond.add(panneauBouton, BorderLayout.SOUTH);
  panneauFond.add(panneauOption, BorderLayout.CENTER);


  JPanel tmp = new JPanel();
  labcx.setFont(font);
  tmp.add(labcx);
  tmp.add(cx);
  panneauOption.add(tmp);
  
  tmp = new JPanel();
  labcy.setFont(font);
  tmp.add(labcy);
  tmp.add(cy);
  panneauOption.add(tmp);

  tmp = new JPanel();
  labThe.setFont(font);
  tmp.add(labThe);
  tmp.add(theta);
  panneauOption.add(tmp);
  
  
  panneauBouton.add(okButton, null);
  panneauBouton.add(appButton, null);
  panneauBouton.add(closeButton, null);




}


  void okButton_actionPerformed(ActionEvent e) {
  double dx = 0, dy = 0, the = 0.;
  if (cx.isValid())
  	  {
  	  dx = cx.getValue();
  	  }
  if (cy.isValid())
  	  {
  	  dy = cy.getValue();
  	  }
  if (theta.isValid())
  	  {
  	  the = theta.getValue();
  	  }
  if (set == true)
  	{
	afft.setToRotation(the,dx,dy);
	}
  else
  	{
	afft.rotate(the,dx,dy);
	}
  if (afftEditor!=null) afftEditor.updateField();
  dispose();
  }

  void appButton_actionPerformed(ActionEvent e) {
  double dx = 0, dy = 0, the = 0.;
  if (cx.isValid())
  	  {
  	  dx = cx.getValue();
  	  }
  if (cy.isValid())
  	  {
  	  dy = cy.getValue();
  	  }
  if (theta.isValid())
  	  {
  	  the = theta.getValue();
  	  }
  if (set == true)
  	{
	afft.setToRotation(the,dx,dy);
	}
  else
  	{
	afft.rotate(the,dx,dy);
	}
  if (afftEditor!=null) afftEditor.updateField();
  
  }

  void closeButton_actionPerformed(ActionEvent e) {
 dispose();

  }


}
