/*
 * Decompiled with CFR 0.152.
 */
package opale.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import opale.tools.InvalidFormatException;

public class StreamReader
extends BufferedReader {
    private String stemp;
    private StringTokenizer st;

    public StreamReader(Reader reader) {
        super(reader);
    }

    public StreamReader(Reader reader, int n) {
        super(reader, n);
    }

    public StreamReader(String string) throws IOException {
        super(new FileReader(string));
    }

    public String next() throws IOException {
        if (this.st != null) {
            if (this.st.hasMoreTokens()) {
                return this.st.nextToken();
            }
            this.stemp = this.readLine();
            if (this.stemp == null) {
                return null;
            }
            this.st = new StringTokenizer(this.stemp);
            return this.next();
        }
        return null;
    }

    public boolean hasMoreTokens() throws IOException {
        if (this.st != null && this.st.hasMoreTokens()) {
            return true;
        }
        this.stemp = this.readLine();
        if (this.stemp == null) {
            return false;
        }
        this.st = new StringTokenizer(this.stemp);
        return this.hasMoreTokens();
    }

    public double nextDouble() throws InvalidFormatException, IOException {
        String string = this.next();
        try {
            if (string == null) {
                throw new InvalidFormatException("Invalid format stream : no double to read !!!");
            }
            Double d = new Double(string);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException("Invalid format stream : " + string + " is not a double !!!");
        }
    }

    public int nextInteger() throws InvalidFormatException, IOException {
        String string = this.next();
        try {
            if (string == null) {
                throw new InvalidFormatException("Invalid format stream : no integer to read !!!");
            }
            Integer n = new Integer(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException("Invalid format stream : " + string + " is not an integer !!!");
        }
    }
}

