/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d;

import java.io.IOException;
import java.io.PrintWriter;
import opale.m2d.AffineTransform2D;
import opale.m2d.Matrix2D;
import opale.m2d.OIJ;
import opale.m2d.Object2D;
import opale.m2d.Point2D;
import opale.m2d.Transformable;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;
import opale.tools.StreamReader;

public class Vector2D
extends Object2D
implements Transformable,
Cloneable {
    protected double x;
    protected double y;

    public Vector2D() {
        Debug.print("ici dan Vector2D");
    }

    public Vector2D(OIJ oIJ) {
        super(oIJ);
    }

    public Vector2D(OIJ oIJ, double d, double d2) {
        super(oIJ);
        this.x = d;
        this.y = d2;
    }

    public Vector2D(Vector2D vector2D) {
        super(vector2D.getOIJ());
        this.x = vector2D.x;
        this.y = vector2D.y;
    }

    public Vector2D(Point2D point2D, Point2D point2D2) {
        super(point2D.getOIJ());
        Point2D point2D3 = (Point2D)point2D2.clone();
        point2D3.changeOIJ(point2D.getOIJ());
        this.x = point2D3.x - point2D.x;
        this.y = point2D3.y - point2D.y;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final void set(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public final void set(Vector2D vector2D) {
        Vector2D vector2D2 = (Vector2D)vector2D.clone();
        if (!vector2D2.getOIJ().equals(this.getOIJ())) {
            vector2D2.changeOIJ(this.getOIJ());
        }
        this.set(vector2D2.x, vector2D2.y);
    }

    public final double normSq() {
        return this.getOIJ().normSq(this.x, this.y);
    }

    public final double norm() {
        return Math.sqrt(this.normSq());
    }

    public static final double normSq(double d, double d2) {
        return d * d + d2 * d2;
    }

    public static double norm(double d, double d2) {
        return Math.sqrt(Vector2D.normSq(d, d2));
    }

    public static double normSq(Vector2D vector2D) {
        return vector2D.getOIJ().normSq(vector2D.x, vector2D.y);
    }

    public static double norm(Vector2D vector2D) {
        return Math.sqrt(Vector2D.normSq(vector2D));
    }

    public boolean equals(Object object) {
        if (object instanceof Vector2D) {
            Vector2D vector2D = (Vector2D)object;
            return this.x == vector2D.x && this.y == vector2D.y && this.getOIJ().equals(vector2D.getOIJ());
        }
        return false;
    }

    public Object clone() {
        Vector2D vector2D = (Vector2D)super.clone();
        vector2D.x = this.x;
        vector2D.y = this.y;
        return vector2D;
    }

    public void translate(double d, double d2) {
    }

    public void rotate(double d) {
        Point2D point2D = new Point2D(this.getOIJ(), this.x, this.y);
        point2D.rotate(d);
        this.set(point2D.x, point2D.y);
    }

    public void rotate(double d, double d2, double d3) {
        this.translate(-d, -d2);
        this.rotate(d3);
        this.translate(d, d2);
    }

    public void transform(AffineTransform2D affineTransform2D) {
        double[] dArray = new double[]{0.0, 0.0, this.x, this.y};
        double[] dArray2 = new double[4];
        affineTransform2D.transform(dArray, 0, dArray2, 0, 2);
        this.x = dArray2[2] - dArray2[0];
        this.y = dArray2[3] - dArray2[1];
    }

    public void changeOIJ(OIJ oIJ) {
        Matrix2D matrix2D = new Matrix2D();
        this.getOIJ().matPassage(oIJ, matrix2D);
        double[] dArray = matrix2D.compute(this.x, this.y);
        double[] dArray2 = matrix2D.compute(0.0, 0.0);
        this.set(dArray[0] - dArray2[0], dArray[1] - dArray2[1]);
        this.setOIJ(oIJ);
    }

    public String toString() {
        String string = "(" + this.x + "; " + this.y + ")";
        return string;
    }

    public void writeMore(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        printWriter.println("X " + this.x);
        printWriter.println("Y " + this.y);
    }

    public int readKeyWord(String string, StreamReader streamReader, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("X")) {
            this.x = streamReader.nextDouble();
            return 0;
        }
        if (string.equals("Y")) {
            this.y = streamReader.nextDouble();
            return 0;
        }
        return -1;
    }
}

