/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.io.PrintWriter;
import opale.m2d.Matrix2D;
import opale.m2d.OIJ;
import opale.m2d.Object2D;
import opale.m2d.Point2D;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;
import opale.tools.StreamReader;

public final class AffineTransform2D
extends Object2D {
    private AffineTransform afft;

    public AffineTransform2D() {
        this.afft = new AffineTransform();
    }

    public AffineTransform2D(OIJ oIJ) {
        super(oIJ);
        this.afft = new AffineTransform();
    }

    public AffineTransform2D(AffineTransform2D affineTransform2D) {
        super(affineTransform2D.getOIJ());
        this.afft = new AffineTransform(affineTransform2D.afft);
    }

    public AffineTransform2D(double d, double d2, double d3, double d4, double d5, double d6) {
        this.afft = new AffineTransform(d, d2, d3, d4, d5, d6);
    }

    public AffineTransform2D(double[] dArray) {
        this.afft = new AffineTransform(dArray);
    }

    public void getMatrix(double[] dArray) {
        this.afft.getMatrix(dArray);
    }

    public double getScaleX() {
        return this.afft.getScaleX();
    }

    public double getScaleY() {
        return this.afft.getScaleY();
    }

    public double getShearX() {
        return this.afft.getShearX();
    }

    public double getShearY() {
        return this.afft.getShearY();
    }

    public double getTranslateX() {
        return this.afft.getTranslateX();
    }

    public double getTranslateY() {
        return this.afft.getTranslateY();
    }

    public void translate(double d, double d2) {
        this.afft.translate(d, d2);
    }

    public void scale(double d, double d2) {
        this.afft.scale(d, d2);
    }

    public void rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        OIJ oIJ = this.getOIJ();
        double d4 = 1.0 / Math.sin(oIJ.getTheta());
        double d5 = Math.cos(oIJ.getTheta()) * d4 * d3;
        double d6 = Math.sqrt(oIJ.normSqI());
        double d7 = Math.sqrt(oIJ.normSqJ());
        double d8 = d2 - d5;
        double d9 = -d3 * d4 / d6;
        double d10 = d3 * d4 / d7;
        double d11 = d2 + d5;
        double[] dArray = new double[6];
        this.afft.getMatrix(dArray);
        double d12 = d8 * dArray[0] + d10 * dArray[2];
        double d13 = d9 * dArray[0] + d11 * dArray[2];
        double d14 = d8 * dArray[1] + d10 * dArray[3];
        double d15 = d9 * dArray[1] + d11 * dArray[3];
        this.afft.setTransform(d12, d14, d13, d15, dArray[4], dArray[5]);
    }

    public void rotate(double d, double d2, double d3) {
        this.translate(d2, d3);
        this.rotate(d);
        this.translate(-d2, -d3);
    }

    public void shear(double d, double d2) {
        System.err.println("shear transformation not available for the moment !!!");
        System.exit(-1);
    }

    public void setToIdentity() {
        this.afft.setToIdentity();
    }

    public void setToTranslation(double d, double d2) {
        this.afft.setToTranslation(d, d2);
    }

    public void setToScale(double d, double d2) {
        this.afft.setToScale(d, d2);
    }

    public void setToRotation(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        OIJ oIJ = this.getOIJ();
        double d4 = 1.0 / Math.sin(oIJ.getTheta());
        double d5 = Math.cos(oIJ.getTheta()) * d4 * d3;
        double d6 = Math.sqrt(oIJ.normSqI());
        double d7 = Math.sqrt(oIJ.normSqJ());
        double d8 = d2 - d5;
        double d9 = -d3 * d4 / d6;
        double d10 = d3 * d4 / d7;
        double d11 = d2 + d5;
        this.afft.setTransform(d8, d10, d9, d11, 0.0, 0.0);
    }

    public void setToRotation(double d, double d2, double d3) {
        Debug.print("No optimizations for the moment in AffineTransform2D::setToRotation");
        this.setToTranslation(d2, d3);
        this.rotate(d);
        this.translate(-d2, -d3);
    }

    public void setTransform(AffineTransform2D affineTransform2D) {
        this.afft.setTransform(affineTransform2D.afft);
    }

    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.afft.setTransform(d, d2, d3, d4, d5, d6);
    }

    public void transform(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[6];
        this.afft.getMatrix(dArray3);
        dArray2[0] = dArray3[0] * dArray[0] + dArray3[2] * dArray[1] + dArray3[4];
        dArray2[1] = dArray3[1] * dArray[0] + dArray3[3] * dArray[1] + dArray3[5];
    }

    public void transform(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n) {
        double[] dArray5 = new double[6];
        this.afft.getMatrix(dArray5);
        while (n-- > 0) {
            double d = dArray[n];
            double d2 = dArray2[n];
            dArray3[n] = dArray5[0] * d + dArray5[2] * d2 + dArray5[4];
            dArray4[n] = dArray5[1] * d + dArray5[3] * d2 + dArray5[5];
        }
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.afft.transform(dArray, n, dArray2, n2, n3);
    }

    public void transform(Point2D point2D) {
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        double[] dArray2 = new double[2];
        if (this.getOIJ().equals(point2D.getOIJ())) {
            this.transform(dArray, dArray2);
            point2D.setLocation(dArray2[0], dArray2[1]);
        } else {
            Debug.print("No optimizations for the moment in AffineTransform2D::transform(Point2D)");
            Matrix2D matrix2D = new Matrix2D();
            point2D.getOIJ().matPassage(this.getOIJ(), matrix2D);
            double[] dArray3 = matrix2D.compute(dArray[0], dArray[1]);
            this.transform(dArray3, dArray2);
            this.getOIJ().matPassage(point2D.getOIJ(), matrix2D);
            dArray2 = matrix2D.compute(dArray2[0], dArray2[1]);
            point2D.setLocation(dArray2[0], dArray2[1]);
        }
    }

    public void writeMore(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        double[] dArray = new double[6];
        this.afft.getMatrix(dArray);
        printWriter.println("Matrix \t" + dArray[0] + " " + dArray[2] + " " + dArray[4]);
        printWriter.println("\t" + dArray[1] + " " + dArray[3] + " " + dArray[5]);
    }

    public int readKeyWord(String string, StreamReader streamReader, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("Matrix")) {
            double d = streamReader.nextDouble();
            double d2 = streamReader.nextDouble();
            double d3 = streamReader.nextDouble();
            double d4 = streamReader.nextDouble();
            double d5 = streamReader.nextDouble();
            double d6 = streamReader.nextDouble();
            this.afft.setTransform(d, d4, d2, d5, d3, d6);
            return 0;
        }
        return -1;
    }

    public void changeOIJ(OIJ oIJ) {
        Debug.print("No optimizations for the moment in AffineTransform2D::changeOIJ");
        Matrix2D matrix2D = new Matrix2D();
        oIJ.matPassage(this.getOIJ(), matrix2D);
        double[][] dArray = matrix2D.getMatrix();
        try {
            AffineTransform affineTransform = new AffineTransform(dArray[0][0], dArray[1][0], dArray[0][1], dArray[1][1], dArray[0][2], dArray[1][2]);
            AffineTransform affineTransform2 = affineTransform.createInverse();
            this.afft.concatenate(affineTransform);
            affineTransform2.concatenate(this.afft);
            this.afft.setTransform(affineTransform2);
            this.setOIJ(oIJ);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            System.err.println(noninvertibleTransformException);
        }
    }

    public boolean isIdentity() {
        return this.afft.isIdentity();
    }

    public String toString() {
        return this.afft.toString();
    }
}

