/*
Copyright (C) 2000  Groupe Opale

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.object2d;
import java.io.*;
import opale.m2d.*;
import opale.tools.*;
import opale.mathtools.*;

/**
* Cette classe tend <code>xyFt</code> et reprsente graphiquemnet une fonction paramtrique x(t), y(t)..
* @since Opale-2d 0.11
* @author O.C.
*/

public class GxyFt extends xyFt implements Cloneable
{
private InfoData info; 

/**
* Constructeur par dfaut.
*/
public GxyFt()
	{
	super();
	System.out.println("Dans GxyFt()");
	info = new InfoData();
	}

/**
* Construit et initialise le nuage avec 0 points et avec les informations par dfaut.  
* @param OIJ rep, le repre.
*/
public GxyFt(OIJ rep)
	{
	super(rep);
	tinf = tsup = 0;
	info = new InfoData();
	}


/**
* Le constructeur de copie
* @param GData d, l'objet  copier.
*/
public GxyFt(GxyFt f)
	{
	super(f);
	this.tinf = f.tinf;
	this.tsup = f.tsup;
	N = f.N;
	info = f.info;
	
	}


public void draw(Pen2D c)
	{

	double[] x = new double[N];
	double[] y = new double[N];
	int i;
	double pas = Math.abs(tsup-tinf)/(N-1),t;
	
	for (i=0;i<N;i++)
		{
		t =tinf + i*pas; 
		x[i] = fonc.x(t);;
		y[i] = fonc.y(t);
		}
	if ( info.isVisible())
		{
		c.setColor(info.getColor());
		if ( info.getTypeGraph() == 0)
			for (i=0;i<N-1;i++)
				c.drawLine(x[i],y[i],x[i+1],y[i+1]);
		else if  ( info.getTypeGraph() == 1)
			{}
		else  if  (info.getTypeGraph() == 2)		
			for (i=0;i<N;i++)
				c.drawLine(x[i],0,x[i],y[i]);
		else  if  (info.getTypeGraph() == 3)		
			for (i=0;i<N;i++)
				c.drawLine(0,y[i],x[i],y[i]);
		else if  ( info.getTypeGraph() == 4) 
			for (i=0;i<N;i++)
				{
				c.drawLine(x[i],0,x[i],y[i]);
				c.drawLine(0,y[i],x[i],y[i]);
				}
		int symb = info.getStylePoint();
		int taille = info.getSizePoint();
		if (symb == 1)
			for (i=0;i<N;i++)
				c.drawPoint(x[i],y[i]);
		else if (symb == 2)			
			for (i=0;i<N;i++)
				c.drawPlus(x[i],y[i],taille);
		else if ( symb == 3)	//on dessine un X      
			for (i=0;i<N;i++)
				c.drawX(x[i],y[i],taille);
		else if ( symb == 4)	//on dessine un cercle      
			for (i=0;i<N;i++)
				c.drawCircle(x[i],y[i],taille);
		else if ( symb == 5)	//on dessine un carr       
			for (i=0;i<N;i++)
				c.drawSquare(x[i],y[i],taille);
		else if ( symb == 6)	//on dessine un diamant       
			for (i=0;i<N;i++)
				c.drawDiamond(x[i],y[i],taille);
		else if ( symb == 7)	//on dessine un triangle haut
			for (i=0;i<N;i++)
				c.drawTriangleUp(x[i],y[i],taille);
		else if ( symb == 8)	//on dessine un triangle bas
			for (i=0;i<N;i++)
				c.drawTriangleDown(x[i],y[i],taille);
		else if ( symb == 9)	//on dessine un triangle gauche
			for (i=0;i<N;i++)
				c.drawTriangleLeft(x[i],y[i],taille);
		else if ( symb == 10)	//on dessine un triangle droit
			for (i=0;i<N;i++)
				c.drawTriangleRight(x[i],y[i],taille);
		}



	}
	
public InfoObject getInfo()
	{
	return info;
	}
	
public int readKeyWord(String word, StreamTokenizer f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	if ( word.equals("INFO"))
		{
		info.read(f,p);
		return 0;
		}
	else return super.readKeyWord(word,f,p);
	}

public void writeMore(PrintWriter f, OpaleSet p)
	{
	info.write(f,p);
	super.writeMore(f,p);
	}	

	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	GxyFt gy = (GxyFt) super.clone();
	return gy;
	}

}
