/*
 * Decompiled with CFR 0.152.
 */
package opale.ode.scheme;

import opale.mathtools.DVect;
import opale.mathtools.FixPoint;
import opale.mathtools.IFnn;
import opale.ode.Equation;
import opale.ode.TimeScheme;

public final class ThetaScheme
extends TimeScheme {
    private double theta;
    private func f = new func();

    public ThetaScheme() {
        this.theta = 0.5;
    }

    public ThetaScheme(double d) {
        this.theta = d;
    }

    public void forward(Equation equation) {
        boolean bl = false;
        boolean bl2 = false;
        DVect dVect = new DVect(this.present());
        this.f.eq = equation;
        this.f.theta = this.theta;
        FixPoint.solve(this.f, this.present().size(), this.present(), dVect);
        this.present().set(dVect);
    }

    public String toString() {
        return "theta Scheme";
    }

    private class func
    implements IFnn {
        Equation eq;
        double theta;

        private func() {
        }

        public DVect val(DVect dVect) {
            double d = 1.0 - this.theta;
            int n = 0;
            while (n < ThetaScheme.this.present().size()) {
                dVect.set(n, this.theta * ThetaScheme.this.present().get(n) + d * dVect.get(n));
                ++n;
            }
            dVect.set(this.eq.derivs(ThetaScheme.this.time(), dVect));
            int n2 = 0;
            while (n2 < ThetaScheme.this.present().size()) {
                dVect.set(n2, ThetaScheme.this.present().get(n2) + ThetaScheme.this.dt() * dVect.get(n2));
                ++n2;
            }
            return dVect;
        }
    }
}

