package otests.matrix.FullLU;

import opale.tools.*;
import opale.mathtools.*;
import opale.matrix.*;
import opale.matrix.solver.*;


public class FullLU implements OTest
{
public  void run(String path)
	{
	Matrix A = new Matrix (100,100);
	DVect b = new DVect(100);
	DVect x = new DVect(100);
	
	for (int i=0;i<100;i++)
		{
		b.set(i,Math.random()*100);
		for(int j = 0;j <100;j++)
			A.set(i,j,Math.random()*100);
		 }
	System.out.println(A);
		 
	Matrix AA=(Matrix)A.clone();	 
	SolverLU lu = new SolverLU();
	lu.decomp(A);
	lu.solve(null,b,x);

	System.out.println("det = " +lu.determinant());
	
	
	DVect err = new DVect(100);
	double tmp;
	for (int i=0;i<100;i++)
		{
		tmp = 0-b.get(i);
		for(int j = 0;j <100;j++)
				tmp +=AA.get(i,j)*x.get(j);
		err.set(i,tmp);
		}
	if (err.getMax() > 1e-10 ) throw new Error("Bad LU inversion !!");
	System.out.println("Err = "+err.getMax());
	
	}
public void stop()
	{
	}
	
}
