package opale.swools;

import java.awt.*;
import javax.swing.*;

/**  This class provides a set of (growing ?) utilities for  
 *  the manipulation of the GridBagLayout and the associate object GridBagConstraints 
 * 
 * @author Romain Pacanowski
 * @version 0.1
 * @since Ople-swools 0.11
 */

public class OGBLayoutUtilities {

   
  /** Set the GridBagConstraint's parameters
   *@param GridBagConstraints gbc, the GridBagConstraints
   *@param int weightx,      Specifies how to distribute extra horizontal space.
   *@param int weighty,      Specifies how to distribute extra vertical space.
   *@param int insetsLeft    The inset from  the left
   *@param int insetsRight   The inset from the right
   *@param int insetsTop     The inset from the top
   *@param int insetsBottom  The inset from the bottom
   *@see  java.awt.GridBagConstraints 
   *@see  java.awt.Insets
   */

  public static void setConstraints(GridBagConstraints gbc , int weightx ,int weighty, int insetsLeft , 
			 int insetsRight , int insetsTop, int insetsBottom ){
    gbc.weightx =weightx ;
    gbc.weighty =weighty ;

    gbc.insets.left = insetsLeft;
    gbc.insets.right = insetsRight;

    gbc.insets.top = insetsTop;
    gbc.insets.bottom = insetsBottom;

  }
  
  /** Add a component to a GridBagLayout a positon (x,y) with an weight w and height in a Container a 
   *@param Component c, the Component to add
   *@param GridBagConstraints gbc, the GridBagConstraints
   *@param int x , abscissa of the component
   *@param int y , ordinate of the component
   *@param int w , weight of the component
   *@param int h , height of the component
   *@param Container a, the container where the component will be add to. 
   *@see java.awt.GridBagConstraints
  */
  public static void add(Component c , GridBagConstraints gbc , int x , int y , int w , int h, Container a){

    gbc.gridx = x ;
    gbc.gridy = y ;
    gbc.gridwidth = w;
    gbc.gridheight = h;
    a.add(c,gbc);

  }





}
