/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/
package opale.ode;

import opale.mathtools.*;
import opale.tools.*;
import java.io.*;

/**
* Class to implement a method of step control. Instances of this class must be associated to a time scheme.
* @since Opale-ODE 0.11
* @author O.C.
*/
public abstract class StepsizeControl extends ObjectODE
{
private TimeScheme ts;

/**
* 
*/
public StepsizeControl()
	{
	this.ts = null;
	}

/**
* constructs an instance a with a specified time scheme.
*/
public StepsizeControl(TimeScheme ts)
	{
	this.ts = ts;
	}

/**
* Returns the time scheme. 
* @return TimeScheme.
*/
public TimeScheme getTS()
	{
	return ts;
	}		

/**
* Sets the time scheme. 
* @param TimeScheme.
*/
public  void setTS(TimeScheme ts)
	{
	this.ts=ts;
	}		

/**
* Update the step. Returns true if the step is valid, false otherwise.
*/
public abstract boolean update();
}

