/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/
package opale.ode;

import java.io.*;
import opale.mathtools.*;
import opale.mathtools.parser.*;
import opale.tools.*;

/**
* Permet de construire dynamiquement une quation en dfinissant les valeurs de son second membre grace  des chaines de caractres. Ces chaines seront interprtes par un parser. Avec cette classe, il faut se limiter  des problmes de dimension comprise entre 1 et 3 c'est  dire que la fonction vectorielle f est dfinie sur I x R ou I x R ou I x R ; de plus les variables dans cette fonction seront nommes par t, x, y, z dans leur ordre d'apparition.
* @since Opale-ODE 0.1
* @author O.C.
*/

public class SEquation extends ObjectODE implements Equation
{
private int dim;
private String[] fonc;
//private ParseFunction[] parser;
private Parser[] parser;
private double[] resu;

/**
* Prend en argument un tableau de chaines de carcatres correspondant aux composantes de la fonction second memebre de l'quation. Ce tableau ne doit pas comporter plus de 3 lments sinon il est rejet et la fonction non interprt. Si ce tableau compirte 1 lment alors la chaine de caractres ne doit comporter que les variables t et x ; si il en comporte 2 alors les deux chaines doivent comporter les variables t, x, et y ; si enfin il en comporte 3 alors on peut trouver t, x, y , z comme variables dans la chaine. Dans tous les cas si un problme se produit (mauvaise dimension ou mauvaises variables) la mthode renvoie false.
* @param String[], le tableau de chaine de caractres dfinissant les composantes de la fonction second membre.
* @return boolean, true si la fonction a pu etre pars sans problme, false sinon.
*/

public boolean setFunc(String[] f)
	{
	if ((f.length<1) || (f.length>3))
		return false;
	dim = f.length;
//	parser = new ParseFunction[dim];
	parser = new Parser[dim];
	resu = new double[dim];
	fonc = new String[dim];
	int i;
	for (i=0;i<dim;i++)
		{
//		parser[i] = new ParseFunction();
		parser[i] = new Parser();
		parser[i].addVar("t");
		parser[i].addVar("x");
/*		if (parser[i].parse(f[i]))
		{
		boolean[] b = parser[i].getVariables();
		if ( ((dim==1) &&( b[1] || b[2])) || ((dim==2) &&(b[2])) )
			return false;
		}
		else 
			return false;*/
		switch (dim)
			{
			case 2:
			parser[i].addVar("y");
			break;
			case 3:
			parser[i].addVar("y");
			parser[i].addVar("z");
			break;
			}	
		parser[i].parseString(f[i]);	
		fonc[i] = f[i];
		}
		
	return true;
	
	}

/**
* Returns the string representation of the composante i of the function.
* @param int i
* @return String 
*/
public String getFunc(int i)
	{
	if ((i>=0) && (i<3))
		return fonc[i];
	return null;
	}

/**
* Get the space dimension of the unknown.
* @return int, the dimension.
*/
public int dim()
	{
	return dim;
	}

/**
* Defines the function of the equation.
* @param double t, time parameter (=derivation parameter).
* @param DVect x, unknown parameters.
* @return DVect, the value of the function at the point (t,x).
*/
public DVect derivs(double t, DVect x)
	{
	int i;
	parser[0].setVar("t",t);
	parser[0].setVar("x",x.get(0));
	
	switch (dim)
		{
		case 1:
		resu[0] = parser[0].eval();
		break;
		case 2:
		parser[0].setVar("y",x.get(1));
		parser[1].setVar("x",x.get(0));
		parser[1].setVar("y",x.get(1));
		resu[0] = parser[0].eval();
		resu[1] = parser[1].eval();
		break;
		case 3:
		parser[0].setVar("y",x.get(1));
		parser[0].setVar("z",x.get(2));
		parser[1].setVar("x",x.get(0));
		parser[1].setVar("y",x.get(1));
		parser[1].setVar("z",x.get(2));
		parser[2].setVar("x",x.get(0));
		parser[2].setVar("y",x.get(1));
		parser[2].setVar("z",x.get(2));
		resu[0] = parser[0].eval();
		resu[1] = parser[1].eval();
		resu[2] = parser[2].eval();
		break;
		}
	/*else if (dim == 2)
		{
		resu[0] = parser[0].getResult(t,x.get(0),x.get(1),0);
		resu[1] = parser[1].getResult(t,x.get(0),x.get(1),0);
		}
	else if (dim == 3)
		{
		resu[0] = parser[0].getResult(t,x.get(0),x.get(1),x.get(2));
		resu[1] = parser[1].getResult(t,x.get(0),x.get(1),x.get(2));
		resu[2] = parser[2].getResult(t,x.get(0),x.get(1),x.get(2));
		}*/
/*	catch(Exception e)
		{
		System.err.println(e);
		System.err.println("Erreur de parsing !!!");
		
		}*/
	DVect res=new DVect(resu);
	return res;
	}

public String toString()
	{
	String s="";
	if (dim ==1)
		s = "f(t,x) = "+fonc[0];
	else if (dim == 2)
		{
		s = "f1(t,x,y) = "+fonc[0]+"\n";
		s += "f2(t,x,y) = "+fonc[1];
		}
	else if (dim == 3)
		{
		s = "f1(t,x,y,z) = "+fonc[0]+"\n";
		s += "f2(t,x,y,z) = "+fonc[1]+"\n";
		s += "f3(t,x,y,z) = "+fonc[2];
		}
	return s;
	}	


public int readKeyWord(String word,StreamTokenizer f,OpaleSet ode)  throws java.io.IOException, InvalidFormatException
	{
	int type,i;
	if ( word.equals("f(t,x)="))
		{
		dim = 1;
		type = f.nextToken();
		if (!( f.sval.endsWith("'") && f.sval.startsWith("'")))  throw new InvalidFormatException("Erreur  la lecture de la fonction  : "+f.sval+". La fonction doit tre indique entre guillemets");
		String[] s = new String[1];
		s[0] = f.sval.substring(1,f.sval.length()-1);
		if ( !setFunc(s) ) throw new InvalidFormatException("Erreur  la lecture de la fonction : "+s[0]);
		return 0;
		}
	else if ( word.equals("f1(t,x,y)="))
		{
		dim = 2;
		type = f.nextToken();
		if (!( f.sval.endsWith("'") && f.sval.startsWith("'")))  throw new InvalidFormatException("Erreur  la lecture de la fonction  : "+f.sval+". La fonction doit tre indique entre guillemets");
		String[] s = new String[2];
		s[0] = f.sval.substring(1,f.sval.length()-1);
		type = f.nextToken();
		word = f.sval;
		type = f.nextToken();
		if ( word.equals("f2(t,x,y)="))
			{
			if (!( f.sval.endsWith("'") && f.sval.startsWith("'")))  throw new InvalidFormatException("Erreur  la lecture de la fonction  : "+f.sval+". La fonction doit tre indique entre guillemets");
			s[1] = f.sval.substring(1,f.sval.length()-1);
			}
		else return -1;

		if ( !setFunc(s) ) throw new InvalidFormatException("Erreur  la lecture de la fonction");
		return 0;
		}
	else if ( word.equals("f1(t,x,y,z)="))
		{
		dim = 3;
		type = f.nextToken();
		if (!( f.sval.endsWith("'") && f.sval.startsWith("'")))  throw new InvalidFormatException("Erreur  la lecture de la fonction  : "+f.sval+". La fonction doit tre indique entre guillemets");
		String[] s = new String[3];
		s[0] = f.sval.substring(1,f.sval.length()-1);
		type = f.nextToken();
		word = f.sval;
		type = f.nextToken();
		if ( word.equals("f2(t,x,y,z)="))
			{
			if (!( f.sval.endsWith("'") && f.sval.startsWith("'")))  throw new InvalidFormatException("Erreur  la lecture de la fonction  : "+f.sval+". La fonction doit tre indique entre guillemets");
			s[1] = f.sval.substring(1,f.sval.length()-1);
			}
		else return -1;
		type = f.nextToken();
		word = f.sval;
		type = f.nextToken();
		if ( word.equals("f3(t,x,y,z)="))
			{
			if (!( f.sval.endsWith("'") && f.sval.startsWith("'")))  throw new InvalidFormatException("Erreur  la lecture de la fonction  : "+f.sval+". La fonction doit tre indique entre guillemets");
			s[2] = f.sval.substring(1,f.sval.length()-1);
			}
		else return -1;

		if ( !setFunc(s) ) throw new InvalidFormatException("Erreur  la lecture de la fonction");
		return 0;
		}
	return -1;
		
	}
	
public void write(PrintWriter f, OpaleSet ode) 
	{
	int i;
	f.println("{");
	if ( dim == 1)
		f.println("f(t,x)= '"+fonc[0]+"'");
	else if ( dim == 2)
		{
		f.println("f1(t,x,y)= '"+fonc[0]+"'");
		f.println("f2(t,x,y)= '"+fonc[1]+"'");
		}
	else if ( dim == 3 )
		{
		f.println("f1(t,x,y,z)= '"+fonc[0]+"'");
		f.println("f2(t,x,y,z)= '"+fonc[1]+"'");
		f.println("f3(t,x,y,z)= '"+fonc[2]+"'");
		}
	f.println("}");
	}
	
	
public static void main(String[] arg)
	{
	double[] x = new double[3];
	x[0] = 3;
	x[1] = 1;
	x[2] = -5;
	DVect xx=new DVect(x);
	
	SEquation seq = new SEquation();
	String[] fonc = new String[3];
	fonc[0] = "x*z-y-3*t";
	fonc[1] = "2*x+y*z+t";
	fonc[2] = "-2*x+y-z*t";
	System.err.println(seq.setFunc(fonc));
	System.err.println( seq.derivs(-34,xx).get(2));
	System.err.println( seq);
	
	
	}	
	
}
