/*
Copyright (C) 2000  Groupe Opale

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.object2d;
import opale.m2d.*;
import opale.tools.*;
import opale.m2d.marktype.*;
import java.io.*;

/**
* Cette classe reprsente un nuage de points graphique; elle tend la class <code>Data2D</code>.
* @author O.C.
* @since Opale-2d 0.1
*/


public class GData2D extends Data2D implements GObject2D,  Cloneable
{
private InfoData info; 
private String legende;
//private StyleOfPoint stylept;
private MarkType markType;

/**
* Constructeur par dfaut.
*/
public GData2D()
	{
	super();
	System.out.println("Dans GData2D()");
	info = new InfoData();
	//stylept = new ClassicPoint();
	markType = new ClassicPoint();
	}

/**
* Construit et initialise le nuage avec 0 points et avec les informations par dfaut.  
* @param OIJ rep, le repre.
*/
public GData2D(OIJ rep)
	{
	super(rep);
	info = new InfoData();
	//stylept = new ClassicPoint();
	markType = new ClassicPoint();
	}
/**
* Construit et initialise le nuage  partir d'un Data2D et avec les informations par dfaut.  
* @param Data2D d, le nuage.
*/
public GData2D(Data2D d)
	{
	super(d);
	info = new InfoData();
	//stylept = new ClassicPoint();
	markType = new ClassicPoint();
	}


/**
* Le constructeur de copie
* @param GData d, l'objet  copier.
*/
public GData2D(GData2D d)
	{
	super(d);
	info = new InfoData((InfoData) d.getInfo());
	//stylept = d.stylept.clone();
	markType = (MarkType) d.markType.clone();
	}

public final int readKeyWord(String word, StreamTokenizer f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	if ( word.equals("INFO"))
		{
		info.read(f,p);
		return 0;
		}
	else if ( word.equals("MARK_TYPE"))
		{
		try
		{
		int type;
		type = f.nextToken();
		if (p.getNameObject(f.sval)== null) throw new InvalidFormatException("Unknown type "+f.sval+" !!!");
		//if (Debug.On) Debug.assert(p.getNameObject(f.sval) != null);
		markType = (MarkType)  Class.forName(p.getNameObject(f.sval)).newInstance();
		markType.read(f,p);
		if (Debug.On) Debug.print("MarkType = ",markType.getClass().getName());
		if (Debug.On) Debug.print("MarkType size = ",markType.getMarksize());
		}
		catch(ClassNotFoundException exc)
		{
		throw new InvalidFormatException("Error reading an object of type "+f.sval+" : the class does not exist.");
		}
		catch(IllegalAccessException exc)
		{
		throw new InvalidFormatException("Error reading an object of type "+f.sval+" : access to the class not possible.");
		}
		catch(InstantiationException exc)
		{
		throw new InvalidFormatException("Error reading an object of type "+f.sval+" : class not instantiable.");
		}	
 
		
		return 0;
		}		
		else return super.readKeyWord(word,f,p);
	}

public void writeMore(PrintWriter f, OpaleSet p) throws InvalidFormatException
	{
	f.print("MARK_TYPE "+p.getUserName(markType.getClass().getName())+" ");
	markType.write(f,p);
	info.write(f,p);
	super.writeMore(f,p);
	}	


public void draw(Pen2D c)
	{
	int i;

	if ( info.isVisible())
		{
		c.setColor(info.getColor());
		if ( info.getTypeGraph() == 0)
			for (i=0;i<nbPts-1;i++)
				c.drawLine(x[i],y[i],x[i+1],y[i+1]);
		else if  ( info.getTypeGraph() == 1)
			{}
		else  if  (info.getTypeGraph() == 2)		
			for (i=0;i<nbPts;i++)
				c.drawLine(x[i],0,x[i],y[i]);
		else  if  (info.getTypeGraph() == 3)		
			for (i=0;i<nbPts;i++)
				c.drawLine(0,y[i],x[i],y[i]);
		else if  ( info.getTypeGraph() == 4) 
			for (i=0;i<nbPts;i++)
				{
				c.drawLine(x[i],0,x[i],y[i]);
				c.drawLine(0,y[i],x[i],y[i]);
				}
		int symb = info.getStylePoint();
		int taille = info.getSizePoint();
		for (i=0;i<nbPts;i++)
			markType.draw(c,x[i],y[i]);
		/*if (symb == 1)
			for (i=0;i<nbPts;i++)
				c.drawPoint(x[i],y[i]);
		else if (symb == 2)			
			for (i=0;i<nbPts;i++)
				c.drawPlus(x[i],y[i],taille);
		else if ( symb == 3)	//on dessine un X      
			for (i=0;i<nbPts;i++)
				c.drawX(x[i],y[i],taille);
		else if ( symb == 4)	//on dessine un cercle      
			for (i=0;i<nbPts;i++)
				c.drawCircle(x[i],y[i],taille);
		else if ( symb == 5)	//on dessine un carr       
			for (i=0;i<nbPts;i++)
				c.drawSquare(x[i],y[i],taille);
		else if ( symb == 6)	//on dessine un diamant       
			for (i=0;i<nbPts;i++)
				c.drawDiamond(x[i],y[i],taille);
		else if ( symb == 7)	//on dessine un triangle haut
			for (i=0;i<nbPts;i++)
				c.drawTriangleUp(x[i],y[i],taille);
		else if ( symb == 8)	//on dessine un triangle bas
			for (i=0;i<nbPts;i++)
				c.drawTriangleDown(x[i],y[i],taille);
		else if ( symb == 9)	//on dessine un triangle gauche
			for (i=0;i<nbPts;i++)
				c.drawTriangleLeft(x[i],y[i],taille);
		else if ( symb == 10)	//on dessine un triangle droit
			for (i=0;i<nbPts;i++)
				c.drawTriangleRight(x[i],y[i],taille);*/
		}
	}
	

/**
* Set the mark type of the points.
* @since Opale-2d 0.15
*/	
public void setMarktype(MarkType mt)
	{
	markType = mt;
	}	
	
public InfoObject getInfo()
	{
	return info;
	}
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	GData2D gd = (GData2D) super.clone();
	gd.info = (InfoData) info.clone();
	gd.markType = (MarkType) markType.clone();
	return gd;
	}

public void drawLegend(Pen2D c,int x, int y,int w, int h)
	{
	if ( info.isVisible())
		{
		c.setColor(info.getColor());
		if ( info.getTypeGraph() !=1)
			c.drawLine(x,y+h/2,x+w,y+h/2);
		else 
			{}
		}
	}
	
public String getLegend()
	{
	return info.getName();
	}
public void setLegend(String t)
	{
	info.setName(t);
	}

}
