/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

public final class Polynomial {
    private int deg;
    private double[] coeff;

    public Polynomial(int n) {
        this.construct(n);
    }

    public Polynomial(int n, double[] dArray) {
        this.construct(n, dArray);
    }

    public void construct(int n) {
        this.deg = n >= 0 ? n : -n;
        this.coeff = new double[this.deg + 1];
        n = 0;
        while (n <= this.deg) {
            this.coeff[n] = 0.0;
            ++n;
        }
    }

    public void construct(int n, double[] dArray) {
        this.deg = n >= 0 ? n : -n;
        this.coeff = new double[this.deg + 1];
        n = 0;
        while (n <= this.deg) {
            this.coeff[n] = dArray[n];
            ++n;
        }
    }

    public double get(int n) {
        return this.coeff[n];
    }

    public void set(int n, double d) {
        this.coeff[n] = d;
    }

    public int deg() {
        return this.deg;
    }

    public double eval(double d) {
        double d2 = this.coeff[this.deg];
        int n = this.deg - 1;
        while (n >= 0) {
            d2 = d2 * d + this.coeff[n];
            --n;
        }
        return d2;
    }

    public String toString() {
        String string = "" + this.get(0);
        int n = 1;
        while (n <= this.deg()) {
            string = string + (this.get(n) > 0.0 ? " + " + this.get(n) : " - " + -this.get(n)) + "X^" + n;
            ++n;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Polynomial polynomial = new Polynomial(2);
        polynomial.set(0, 1.0);
        polynomial.set(1, -2.0);
        polynomial.set(2, -4.0);
        System.out.println(polynomial.deg());
        System.out.println(polynomial);
        System.out.println(polynomial.eval(2.0));
    }
}

