/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.object2d;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import opale.m2d.GObject2D;
import opale.m2d.InfoObject;
import opale.m2d.MarkType;
import opale.m2d.OIJ;
import opale.m2d.Pen2D;
import opale.m2d.marktype.ClassicPoint;
import opale.m2d.object2d.Data2D;
import opale.m2d.object2d.InfoData;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;

public class GData2D
extends Data2D
implements GObject2D,
Cloneable {
    private InfoData info;
    private String legende;
    private MarkType markType;

    public GData2D() {
        System.out.println("Dans GData2D()");
        this.info = new InfoData();
        this.markType = new ClassicPoint();
    }

    public GData2D(OIJ oIJ) {
        super(oIJ);
        this.info = new InfoData();
        this.markType = new ClassicPoint();
    }

    public GData2D(Data2D data2D) {
        super(data2D);
        this.info = new InfoData();
        this.markType = new ClassicPoint();
    }

    public GData2D(GData2D gData2D) {
        super(gData2D);
        this.info = new InfoData((InfoData)gData2D.getInfo());
        this.markType = (MarkType)gData2D.markType.clone();
    }

    public final int readKeyWord(String string, StreamTokenizer streamTokenizer, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("INFO")) {
            this.info.read(streamTokenizer, opaleSet);
            return 0;
        }
        if (string.equals("MARK_TYPE")) {
            try {
                int n = streamTokenizer.nextToken();
                if (opaleSet.getNameObject(streamTokenizer.sval) == null) {
                    throw new InvalidFormatException("Unknown type " + streamTokenizer.sval + " !!!");
                }
                this.markType = (MarkType)Class.forName(opaleSet.getNameObject(streamTokenizer.sval)).newInstance();
                this.markType.read(streamTokenizer, opaleSet);
                Debug.print("MarkType = ", this.markType.getClass().getName());
                Debug.print("MarkType size = ", this.markType.getMarksize());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : the class does not exist.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : access to the class not possible.");
            }
            catch (InstantiationException instantiationException) {
                throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : class not instantiable.");
            }
            return 0;
        }
        return super.readKeyWord(string, streamTokenizer, opaleSet);
    }

    public void writeMore(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        printWriter.print("MARK_TYPE " + opaleSet.getUserName(this.markType.getClass().getName()) + " ");
        this.markType.write(printWriter, opaleSet);
        this.info.write(printWriter, opaleSet);
        super.writeMore(printWriter, opaleSet);
    }

    public void draw(Pen2D pen2D) {
        if (this.info.isVisible()) {
            int n;
            pen2D.setColor(this.info.getColor());
            if (this.info.getTypeGraph() == 0) {
                n = 0;
                while (n < this.nbPts - 1) {
                    pen2D.drawLine(this.x[n], this.y[n], this.x[n + 1], this.y[n + 1]);
                    ++n;
                }
            } else if (this.info.getTypeGraph() != 1) {
                if (this.info.getTypeGraph() == 2) {
                    n = 0;
                    while (n < this.nbPts) {
                        pen2D.drawLine(this.x[n], 0.0, this.x[n], this.y[n]);
                        ++n;
                    }
                } else if (this.info.getTypeGraph() == 3) {
                    n = 0;
                    while (n < this.nbPts) {
                        pen2D.drawLine(0.0, this.y[n], this.x[n], this.y[n]);
                        ++n;
                    }
                } else if (this.info.getTypeGraph() == 4) {
                    n = 0;
                    while (n < this.nbPts) {
                        pen2D.drawLine(this.x[n], 0.0, this.x[n], this.y[n]);
                        pen2D.drawLine(0.0, this.y[n], this.x[n], this.y[n]);
                        ++n;
                    }
                }
            }
            int n2 = this.info.getStylePoint();
            int n3 = this.info.getSizePoint();
            n = 0;
            while (n < this.nbPts) {
                this.markType.draw(pen2D, this.x[n], this.y[n]);
                ++n;
            }
        }
    }

    public void setMarktype(MarkType markType) {
        this.markType = markType;
    }

    public InfoObject getInfo() {
        return this.info;
    }

    public Object clone() {
        GData2D gData2D = (GData2D)super.clone();
        gData2D.info = (InfoData)this.info.clone();
        gData2D.markType = (MarkType)this.markType.clone();
        return gData2D;
    }

    public void drawLegend(Pen2D pen2D, int n, int n2, int n3, int n4) {
        if (this.info.isVisible()) {
            pen2D.setColor(this.info.getColor());
            if (this.info.getTypeGraph() != 1) {
                pen2D.drawLine(n, n2 + n4 / 2, n + n3, n2 + n4 / 2);
            }
        }
    }

    public String getLegend() {
        return this.info.getName();
    }

    public void setLegend(String string) {
        this.info.setName(string);
    }
}

