package opale.module2d.noyau2d;
import java.awt.*; 
/**
* Cette classe permet de satisfaire la convention applique dans OPALE, selon laquelle les classes de base des objets gomtriques
* s'appelent Nom et les classes graphiques GNom. Elles hritent de <code>java.awt.geom.Point2D.Double</code> et implmentent l'interface
* <code>Transformable</code>
* @author K.D.
* @version 0.1
*/
public class Nuage2D
{
  int dim;
  double x[];
  double y[];
/**
* Le constructeur par dfaut.
* Initialise les 2 tableaux avec les coordonnes (0; 0).
* @since Opale 0.1
*/
public Nuage2D(int dim)
	{
  double[] x = new double[dim];
  double[] y = new double[dim];

  for(int i=0 ;i<dim ;i++)
   {
    x[i]=0.0;
    y[i]=0.0;
   }
	}

/**
* Construit et initialise le nuage  partir d'un fichier.
* @param *FILE.
* @since Opale 0.1
*/
/**
*public Nuage2D(*FILE file)
*	{
*  ici chargement du tableau  partir d'un fichier.
*	}
/**



/**
* Le constructeur de copie.
* @param Nuage2D le nuage  copier.
* @since Opale 0.1
*/
public Nuage2D(Nuage2D N)
	{
	dim=N.dim;
  double x[] = new double[N.dim];
  double y[] = new double[N.dim];
  for(int i=0;i<N.dim;i++)
    {
     this.x[i] = N.x[i];
     this.y[i] = N.y[i];
    }
	}


// les mthodes de regressions sur le nuage de point.

/** cette mthode ajuste le nuage par une droite  y=mx+b.
*@param Nuage2D le nuage  ajuster.
*@renvoie  un Point2D(m,b).
**/

public Point2D RegLin()
	{

  Point2D p;
  double m,b;
  double sommX = 0;
  double sommY = 0;
  double sommXY = 0;
  double sommXX = 0;

  for(int i=0 ;i<this.dim ;i++)
    {
     sommX+=this.x[i];
     sommY+=this.y[i];
     sommXY+=this.x[i]*this.y[i];
     sommXX+=this.x[i]*this.x[i];
    }

   m=(dim*sommXY-sommX*sommY)/(dim*sommXX-sommX*sommX);

   b=(sommY*sommXX-sommXY)/(dim*sommXX-sommX*sommX);
   
   p = new Point2D(m,b);
   return   p;

	}

/** ajustement exponentiel  y = a * bExp(x).
*@param Nuage2D nuage de point.
*@renvoie a et b.
**/


public Point2D RegExp()
{
 Point2D p;
 Nuage2D M = new Nuage2D(this.dim);
 for(int i=0;i<this.dim;i++)
 {
  M.x[i] = this.x[i];
  M.y[i] = Math.log(this.y[i]);
 }
 p = M.RegLin();
 return p;
}

/** ajustement logarithmique y = a + b ln(x).
*@param Nuage2D nuage de point.
*@renvoie a et b.
**/

public Point2D RegLn()
{
 Point2D p;
 Nuage2D M = new Nuage2D(this.dim);
 for(int i=0;i<this.dim;i++)
 {
  M.x[i] = Math.log(this.x[i]);
  M.y[i] = this.y[i];
 }
 p=M.RegLin();
 return p;
}

/** ajustement puissance  y = a * x^b .
*@param Nuage2D nuage de point.
*@renvoie a et b.
**/

public Point2D RegPwr()
{
 Point2D p;
 Nuage2D M = new Nuage2D(this.dim);
 for(int i=0;i<this.dim;i++)
 {
  M.x[i] = Math.log(this.x[i]);
  M.y[i] = Math.log(this.y[i]);
 }
 p = M.RegLin();
 return p;
}

/** Pour un nuage contenant n points interpolation de Lagrange
par un polynme P du n-1 degr.
*@param double X
*@renvoie Y=P(X).
**/

public double RegLagrange(double X)
{
 double Y = 0;
 double P1 = 1;
 double P2 = 1;
 for(int i=0;i<this.dim;i++)
 {
  for(int j=0;(j<this.dim)&&(j!=i);j++)
  {
   P1=P1*(X-this.x[j]);
   P2=P2*(this.x[i]-this.x[j]);
  }
  Y += this.y[i]*(P1/P2);
 }
 return Y;
}


}
