/*
 * Decompiled with CFR 0.152.
 */
package opale.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Stack;
import opale.tools.InvalidFormatException;
import opale.tools.InvalidIdException;
import opale.tools.OpaleObject;
import opale.tools.Stdio;

public class OpaleSet {
    private HashMap obj = new HashMap();
    private HashMap prior;
    private static HashMap objectName;
    private static HashMap userName;

    public OpaleSet() {
        objectName = new HashMap();
        userName = new HashMap();
        this.prior = new HashMap();
        String string = "";
        String string2 = "";
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("name_object.rsc");
            StreamTokenizer streamTokenizer = null;
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                streamTokenizer = new StreamTokenizer(bufferedReader);
            } else {
                System.err.println("File name_object.rsc not found.");
                System.err.println("Stop.");
                System.exit(-1);
            }
            streamTokenizer.wordChars(33, 255);
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                if (n == -2) {
                    string = Double.toString(streamTokenizer.nval);
                } else if (n == -3) {
                    string = streamTokenizer.sval;
                }
                n = streamTokenizer.nextToken();
                if (n == -2) {
                    string2 = Double.toString(streamTokenizer.nval);
                } else if (n == -3) {
                    string2 = streamTokenizer.sval;
                } else if (n == -1) {
                    System.err.println("Error reading file of configuration.\n Stop.");
                    System.exit(-1);
                }
                n = streamTokenizer.nextToken();
                if (n != -2) {
                    System.err.println("Error reading file of configuration.\n Stop.");
                    System.exit(-1);
                } else {
                    this.prior.put(string, new Double(streamTokenizer.nval));
                }
                objectName.put(string2, string);
                userName.put(string, string2);
                n = streamTokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error reading file of configuration.\n Stop.");
            System.err.println(iOException);
            System.exit(-1);
        }
    }

    public void add(OpaleObject opaleObject) {
        if (opaleObject.getId() == null) {
            throw new InvalidIdException("An Opale object must have an identificator before to be added in an Opale set !!!");
        }
        this.obj.put(opaleObject.getId(), opaleObject);
    }

    public void add(OpaleObject opaleObject, String string) {
        if (string == null) {
            throw new InvalidIdException("An Opale object must have a non null identificator !!!");
        }
        opaleObject.setId(string);
        this.obj.put(opaleObject.getId(), opaleObject);
    }

    public void clear() {
        this.obj.clear();
    }

    public int size() {
        return this.obj.size();
    }

    public void remove(String string) {
        this.obj.remove(string);
    }

    public Collection objects() {
        return this.obj.values();
    }

    public OpaleObject getObject(String string) {
        return (OpaleObject)this.obj.get(string);
    }

    public boolean contains(OpaleObject opaleObject) {
        return this.obj.containsValue(opaleObject);
    }

    public boolean contains(String string) {
        return this.obj.containsKey(string);
    }

    public boolean isEmpty() {
        return this.obj.isEmpty();
    }

    public String[] getUserNameObject() {
        Object[] objectArray = objectName.keySet().toArray();
        String[] stringArray = new String[objectName.size()];
        int n = 0;
        while (n < objectName.size()) {
            stringArray[n] = (String)objectArray[n];
            ++n;
        }
        return stringArray;
    }

    public String getNameObject(String string) {
        return (String)objectName.get(string);
    }

    public String getUserName(String string) {
        return (String)userName.get(string);
    }

    public void read(Reader reader) throws InvalidFormatException {
        BufferedReader bufferedReader = new BufferedReader(reader, 5000);
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.slashStarComments(false);
        streamTokenizer.slashSlashComments(true);
        Stdio.println("Reading the stream : " + bufferedReader);
        try {
            bufferedReader.mark(5000);
            Stdio.println(" ->> Reading the declarations & definitions");
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                if (this.getNameObject(streamTokenizer.sval) == null) {
                    throw new InvalidFormatException("Unknown type " + streamTokenizer.sval + " !!!");
                }
                OpaleObject opaleObject = (OpaleObject)Class.forName(this.getNameObject(streamTokenizer.sval)).newInstance();
                streamTokenizer.nextToken();
                String string = streamTokenizer.sval;
                opaleObject.setId(string);
                opaleObject.read(streamTokenizer, this);
                this.add(opaleObject);
                n = streamTokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error reading the file " + streamTokenizer);
            System.err.println(iOException);
            System.exit(-1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : the class does not exist.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : access to the class not possible.");
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : class not instantiable.");
        }
    }

    public void read(StreamTokenizer streamTokenizer) throws InvalidFormatException {
        Stdio.println("Reading the stream : " + streamTokenizer);
        try {
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                if (this.getNameObject(streamTokenizer.sval) == null) {
                    throw new InvalidFormatException("Unknown type " + streamTokenizer.sval + " !!!");
                }
                OpaleObject opaleObject = (OpaleObject)Class.forName(this.getNameObject(streamTokenizer.sval)).newInstance();
                streamTokenizer.nextToken();
                String string = streamTokenizer.sval;
                opaleObject.setId(string);
                opaleObject.read(streamTokenizer, this);
                this.add(opaleObject);
                n = streamTokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error reading the file " + streamTokenizer);
            System.err.println(iOException);
            System.exit(-1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : the class does not exist.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : access to the class not possible.");
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : class not instantiable.");
        }
    }

    public void write(PrintWriter printWriter) throws InvalidFormatException {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("No objects to write !!!");
        }
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                OpaleObject opaleObject = (OpaleObject)object;
                OpaleObject opaleObject2 = (OpaleObject)object2;
                System.out.println(opaleObject.getClass().getName());
                double d = (Double)OpaleSet.this.prior.get(opaleObject.getClass().getName());
                double d2 = (Double)OpaleSet.this.prior.get(opaleObject2.getClass().getName());
                if (d < d2) {
                    return -1;
                }
                if (d == d2) {
                    return 0;
                }
                return 1;
            }
        };
        OpaleObject[] opaleObjectArray = this.objects().toArray(new OpaleObject[0]);
        Arrays.sort(opaleObjectArray, comparator);
        int n = 0;
        while (n < opaleObjectArray.length) {
            printWriter.print(this.getUserName(opaleObjectArray[n].getClass().getName()) + " ");
            printWriter.println(opaleObjectArray[n].getId());
            opaleObjectArray[n].write(printWriter, this);
            printWriter.println("");
            ++n;
        }
    }

    private int jump(StreamTokenizer streamTokenizer) throws InvalidFormatException {
        try {
            Stack<String> stack = new Stack<String>();
            int n = streamTokenizer.nextToken();
            if (n != -3 || !streamTokenizer.sval.equals("{")) {
                throw new InvalidFormatException("Syntax error : '{' expected !!");
            }
            stack.push("{");
            n = streamTokenizer.nextToken();
            while (!stack.empty() && n != -1) {
                if (n == -3 && streamTokenizer.sval.equals("{")) {
                    stack.push("{");
                } else if (n == -3 && streamTokenizer.sval.equals("}")) {
                    if (stack.empty()) {
                        throw new InvalidFormatException(" Syntax error : '{' expected !!!");
                    }
                    String string = (String)stack.pop();
                    if (!string.equals("{")) {
                        throw new InvalidFormatException(" Syntax error : '{' expected !!!");
                    }
                }
                n = streamTokenizer.nextToken();
            }
            return n;
        }
        catch (IOException iOException) {
            System.err.println("Error reading the file " + streamTokenizer);
            System.err.println(iOException);
            System.exit(-1);
            return 0;
        }
    }
}

