/*
 * Decompiled with CFR 0.152.
 */
package opale.ode.scheme;

import opale.mathtools.DVect;
import opale.ode.Equation;
import opale.ode.TimeScheme;

public final class Heun
extends TimeScheme {
    private double temp;

    public void forward(Equation equation) {
        DVect dVect = new DVect(this.present().size());
        DVect dVect2 = equation.derivs(this.time(), this.present());
        int n = 0;
        while (n < this.present().size()) {
            dVect.set(n, this.present().get(n) + this.dt() * dVect2.get(n));
            ++n;
        }
        DVect dVect3 = equation.derivs(this.time() + this.dt(), dVect);
        n = 0;
        while (n < this.present().size()) {
            this.present().set(n, this.present().get(n) + 0.5 * this.dt() * (dVect2.get(n) + dVect3.get(n)));
            ++n;
        }
    }

    public String toString() {
        return "Heun";
    }
}

