/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;

public class InfoObject
implements Cloneable {
    private String name;
    private Color color;
    private boolean visible;

    public InfoObject() {
        this.color = Color.black;
        this.name = new String("Sans_nom");
        this.visible = true;
    }

    public InfoObject(InfoObject infoObject) {
        this.color = infoObject.getColor();
        this.name = new String(infoObject.getName());
        this.visible = infoObject.isVisible();
    }

    public void read(StreamTokenizer streamTokenizer, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        int n = streamTokenizer.nextToken();
        if (n != -3 || !streamTokenizer.sval.equals("{")) {
            throw new InvalidFormatException("Fichier de donn\u00e9es au mauvais format !!");
        }
        n = streamTokenizer.nextToken();
        do {
            if (streamTokenizer.sval.equals("NAME")) {
                n = streamTokenizer.nextToken();
                if (n != -3) {
                    throw new InvalidFormatException("Fichier de donn\u00e9es au mauvais format : erreur \u00e0 la lecture du nom d'un objet graphique");
                }
                this.name = streamTokenizer.sval;
                continue;
            }
            if (streamTokenizer.sval.equals("COLOR")) {
                n = streamTokenizer.nextToken();
                if (n != -2) {
                    throw new InvalidFormatException("Erreur \u00e0 la lecture de la couleur d'un objet graphique : on attendait les valeurs R G B");
                }
                int n2 = (int)streamTokenizer.nval;
                n = streamTokenizer.nextToken();
                if (n != -2) {
                    throw new InvalidFormatException("Erreur \u00e0 la lecture de la couleur d'un objet graphique : on attendait les valeurs R G B");
                }
                int n3 = (int)streamTokenizer.nval;
                n = streamTokenizer.nextToken();
                if (n != -2) {
                    throw new InvalidFormatException("Erreur \u00e0 la lecture de la couleur d'un objet graphique : on attendait les valeurs R G B");
                }
                int n4 = (int)streamTokenizer.nval;
                this.color = new Color(n2, n3, n4);
                continue;
            }
            if (streamTokenizer.sval.equals("VISIBLE")) {
                n = streamTokenizer.nextToken();
                if (n != -3) {
                    throw new InvalidFormatException("Fichier de donn\u00e9es au mauvais format : erreur \u00e0 la lecture de la visibilit\u00e9 d'un objet graphique");
                }
                if (streamTokenizer.sval.equals("YES")) {
                    this.setVisible();
                    continue;
                }
                if (streamTokenizer.sval.equals("NO")) {
                    this.setUnvisible();
                    continue;
                }
                throw new InvalidFormatException("Fichier de donn\u00e9es au mauvais format : erreur \u00e0 la lecture de la visibilit\u00e9 d'un objet graphique. On attendait YES ou NO");
            }
            if (this.readKeyWord(streamTokenizer.sval, streamTokenizer, opaleSet) != -1) continue;
            throw new InvalidFormatException("Fichier de donn\u00e9es au mauvais format : erreur de lecture d'un mot cl\u00e9 !!");
        } while ((n = streamTokenizer.nextToken()) != -3 || !streamTokenizer.sval.equals("}"));
    }

    public int readKeyWord(String string, StreamTokenizer streamTokenizer, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        return -1;
    }

    public void write(PrintWriter printWriter, OpaleSet opaleSet) {
        printWriter.println("INFO");
        printWriter.println("\t{");
        printWriter.println("\tNAME " + this.name);
        printWriter.println("\tCOLOR " + this.color.getRed() + " " + this.color.getGreen() + " " + this.color.getBlue());
        if (!this.visible) {
            printWriter.println("\tVISIBLE NO");
        }
        this.writeMore(printWriter, opaleSet);
        printWriter.println("\t}");
    }

    public void writeMore(PrintWriter printWriter, OpaleSet opaleSet) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = new String(string);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible() {
        this.visible = true;
    }

    public void setUnvisible() {
        this.visible = false;
    }

    public Object clone() {
        try {
            return (InfoObject)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

