#!/bin/sh
#Creates an archive opale.jar with all modules.

if [ -z "$OPALE_DIR" ]
then
	echo "OPALE_DIR not initialized !"
	exit -1
fi

if [ -z "$JC" ]
then

JC='jikes '  #Jikes 
#JC='jikes -encoding iso-8859-1 '  #Jikes 
#JC=javac # or javac (Sun, Ibm, Blackdown ...)
fi

echo "---------------------------------------------------------------"
echo "Creates opale.jar in the directory $OPALE_DIR/arch"
echo "---------------------------------------------------------------"

DEST=$OPALE_DIR/arch

$JC  -d $DEST $OPALE_DIR/opale/*.java
#building de opale/tools
echo "building opale.tools..."
$JC  -d $DEST $OPALE_DIR/opale/tools/*.java

echo "building opale.cst..."
$JC  -d $DEST $OPALE_DIR/opale/cst/*.java
$JC  -d $DEST $OPALE_DIR/opale/cst/chemistry/*.java

#building de opale/swools
echo "building opale.swools..."
$JC  -d $DEST $OPALE_DIR/opale/swools/*.java

#building de opale/mathtools
echo "building opale.mathtools..."
$JC  -d $DEST $OPALE_DIR/opale/mathtools/*.java

#building de opale/ode
echo "building opale.ode..."
$JC  -d $DEST $OPALE_DIR/opale/ode/*.java
$JC  -d $DEST $OPALE_DIR/opale/ode/scheme/*.java
cp -rf $OPALE_DIR/opale/ode/name.rsc $DEST/opale/ode

#building de opale/matrix
echo "building opale.matrix..."
$JC  -d $DEST $OPALE_DIR/opale/matrix/*.java
$JC  -d $DEST $OPALE_DIR/opale/matrix/solver/*.java

#building de opale/m2d
echo "building opale.m2d..."
$JC  -d $DEST $OPALE_DIR/opale/m2d/*.java
$JC  -d $DEST $OPALE_DIR/opale/m2d/object2d/*.java
$JC  -d $DEST $OPALE_DIR/opale/m2d/component2d/*.java
cp -rf $OPALE_DIR/opale/m2d/list_object.cfg $DEST/opale/m2d

echo ""
echo "Building opale.jar..."
cd $DEST
jar cfm opale.jar $OPALE_DIR/utils/sh/Manifest opale
