package otests.ode.ee2d;

import opale.tools.*;
import opale.mathtools.*;
import opale.ode.*;
import opale.ode.scheme.*;


public class ee2d implements OTest
	{
	
	public void run(String path)
	{
	
	Problem pb = new Problem(2);
	ExplicitEuler ts = new ExplicitEuler();
	pb.setEqn(
		new Equation()
			{
			DVect y = new DVect(2);
			public int dim() { return 2; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,-x.get(0)*x.get(0)+x.get(0)*x.get(1));
				y.set(1,-x.get(1)*x.get(1)-x.get(0)*x.get(1));
				return y;
				}
			}
		);
	DVect cd = new DVect(2);
	cd.set(0,1);
	cd.set(1,1);
	pb.setInit(cd);
	ts.set(0,100);
	ts.setNstep(500);
	pb.setTS(ts);
	pb.solve();
	
	try
	{
	WFile wf = new WFile(path+"resu1.txt");
	pb.writeSol(wf);
	wf.writeln("");
	wf.close();
	}
	catch(java.io.IOException e)
	{}	


	}

	public void stop() {};

}
