import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;


public class TestParser extends JFrame implements ActionListener
{
JTextField fonc;
JTextField resu;
DoubleTextField x,y,z,t;
JButton ok;


public TestParser()
	{
	setTitle("Test du parser");
	setSize(300,300);
addWindowListener(new WindowAdapter()
	{
	public void windowClosing(WindowEvent evt)
		{
		System.exit(0);
		}
	}
	);
	
	fonc = new JTextField(40);
	resu = new JTextField(40);
	//resu.isEditable(false);
	
	JPanel p = new JPanel();
	p.setLayout(new  GridLayout(6,2));
	x = new DoubleTextField(0,10);
	y = new DoubleTextField(0,10);
	z = new DoubleTextField(0,10);
	t = new DoubleTextField(0,10);
	p.add(new JLabel("fonction  : "));
	p.add(fonc);
	p.add(new JLabel("X = "));
	p.add(x);
	p.add(new JLabel("Y = "));
	p.add(y);
	p.add(new JLabel("Z = "));
	p.add(z);
	p.add(new JLabel("T = "));
	p.add(t);
	p.add(new JLabel("resu = "));
	p.add(resu);
	
	
	Container contentPane = getContentPane();
	contentPane.setLayout(new BorderLayout());
	contentPane.add(p,"North");

	ok = new JButton("Evaluer");
	contentPane.add(ok,"South");

	ok.addActionListener(this);

	}

public void actionPerformed(ActionEvent evt)
	{
	if (evt.getSource() == ok)
		{
		if (x.isValid() && y.isValid() && z.isValid() && t.isValid())
			{
			ParseFunction parser = new ParseFunction();
			if (!parser.parse(fonc.getText()))
				JOptionPane.showMessageDialog(this,"Erreur dans l'criture de la fonction ","Evaluation impossible",JOptionPane.ERROR_MESSAGE);
			else 
				{
				try
				{
				resu.setText(Double.toString(parser.getResult(t.getValue(),x.getValue(),y.getValue(),z.getValue())));
				}
				catch (Exception e)
				{
				System.err.println(e);
				}
				}
				
			}
		}
	}
public static void main(String[] arg)
	{
	TestParser test = new TestParser();
	test.show();
	}


}

class DoubleTextDocument extends PlainDocument
{  public void insertString(int offs, String str, 
      AttributeSet a) 
      throws BadLocationException 
   {  if (str == null) return;
      String oldString = getText(0, getLength());
      String newString = oldString.substring(0, offs)
         + str + oldString.substring(offs);
      try
      {  Double.parseDouble(newString + "0");
         super.insertString(offs, str, a);
      }
      catch(NumberFormatException e)
      {  
      }
   }
}

class DoubleTextField extends JTextField 
{  public DoubleTextField(double defval, int size)
   {  super("" + defval, size);
   }

   protected Document createDefaultModel() 
   {  return new DoubleTextDocument();
   }

   public boolean isValid()
   {  try
      {  Double.parseDouble(getText());
         return true;
      }
      catch(NumberFormatException e)
      {  return false; 
      }
   }

   public double getValue()
   {  try
      {  return Double.parseDouble(getText());
      }
      catch(NumberFormatException e)
      {  return 0; 
      }
   }
}
